*------------------------------------------------------------------------------
*- Version....: ACCPAC Pro Series 7.30.00
*- File Name..: $Workfile:   SYLKGL.prg  $
*- VCS Level..: $Revision:   1.24  $
*- Last Update: $Date:   08 Jun 2006 15:43:18  $
*------------------------------------------------------------------------------
*- Copyright (C) 2004 ACCPAC International, Inc.  All Rights Reserved.
*------------------------------------------------------------------------------
*- App ID.....: SY
*- App Name...: System Files
*------------------------------------------------------------------------------
*- Description: Update GL account codes
*------------------------------------------------------------------------------
*- Synopsis...: Release postings from AP, AR, or IC subledgers and create
*-              unposted GL batches.
*------------------------------------------------------------------------------
*- Calls......: APLKGL.FRM, ARLKGL.FRM, ICLKGL.FRM, SYLKGL.FRM, G_RETACT(),
*-              G_DSPBX
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: gc_idrvdbf, gc_idrvtmp, gc_tmpf1, gc_tmpf2
*-
*- Parameters.: None
*-
*- Files Open.: Opens source APDIST/ARDIST/ICDIST file, SYCDFIS, and
*-              destination GLACNT, GLBTCH, GLDUNP, and GLHUNP files.
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: None
*-
*- Parameters.: None
*-
*- Files Open.: Closes any files opened here.
*------------------------------------------------------------------------------
#define Cn_TopRec         20090    && Top record.

*-- HOOK BEGIN: <ACS>: Setup
IF gl_acs AND gl_acs_upos
  IF TYPE("ll_insylkgl") = "U"
    PRIVATE ll_insylkgl
    ll_insylkgl = .t.
    DO (gc_idrvprg + "sylkglu.prg") WITH "1"
    RETURN
  ENDIF
ENDIF
*-- HOOK END: <ACS>: Setup

PRIVATE ll_flgsy, ;
        ll_flggl, ;
        ln_glsys, ;
        ln_rlsys, ;
        ll_cont, ;
        lc_aldist, ;
        ln_curr, ;
        ll_curr, ;
        lc_alydst, ;
        ln_hist, ;
        ll_hist, ;
        lc_detail, ;
        lc_text5, ;
        lc_text1, ;
        lc_text2, ;
        lc_text3, ;
        lc_text4, ;
        ln_bal, ;
        lc_lastses, ;
        lc_glcomp, ;
        lc_alytrn, ;
        lc_altran, ;
        lc_alycsh, ;
        lc_alcash, ;
        lc_title, ;
        lc_suspen, ;
        lc_curcond, ;
        lc_hiscond, ;
        lc_currtag, ;
        lc_histag, ;
        lc_prttag

*\ [Begin] PTR# 74180 06/23/04 TIAI Fix for performance optimization
PRIVATE lf_Ftemp7, ;
        lf_Ftemp9, ;
        lf_Stemp4, ;
        lf_Stemp5, ;
        lf_Stemp8, ;
        lf_Stemp10

lf_Ftemp7 = go_SQL.m_getTempTableName(7, "F")
lf_Ftemp9 = go_SQL.m_getTempTableName(9, "F")
lf_Stemp4 = go_SQL.m_getTempTableName(4)
lf_Stemp5 = go_SQL.m_getTempTableName(5)
lf_Stemp8 = go_SQL.m_getTempTableName(8)
lf_Stemp10 = go_SQL.m_getTempTableName(10)
*\ [End] PTR# 74180 06/23/04 TIAI Fix for performance optimization

LOCAL lo_Save

*-- Setup continuation flags
ll_cont  = .t.
ll_flgsy = .f.
ll_flggl = .f.

*-- If not linked to GL
IF NOT gl_gllink

  *-- Display alert
  DO g_dspalt WITH "Not linked to General Ledger.  Unable to" + ;
                   gc_oseol + "release entries.", 3

  *-- Set flag to cancel
  ll_cont = .f.
ENDIF

*-- Setup variables for system file and saved environment
ln_rlsys  = 0
ln_glsys  = 0
lc_glcomp = ""
lc_suspen = ""
lc_title  = ""
lc_detail = ""

*-- File alias variables
lc_alcash = ""
lc_alycsh = ""
lc_altran = ""
lc_alytrn = ""
lc_alydst = ""
lc_aldist = ""

*-- Current/history flags
ll_curr = .f.
ln_curr = 0
ll_hist = .f.
ln_hist = 0

*-- Setup the variables used to store the validation expression for dist files
lc_curcond = ""
lc_hiscond = ""
lc_currtag = "C" + LEFT(SYS(3),7)
lc_histag  = "H" + LEFT(SYS(3),7)
lc_prttag  = "P" + LEFT(SYS(3),7)

*-- If not cancelled
IF ll_cont
  *-- Display processing message
  DO g_dspst WITH "Checking and setting system flags...", .t., ;
                  gn_msgline, "", "", ""

  *-- Lock SYSDATA file
  go_SQL.m_TableChangeCurrent("a_sysdat")
  = (go_SQL.cmpA_Sysdat.m_LockFile(-1, .f.))

  *-- Find application record to check release
  ln_rlsys = g_setsys(gc_applid, gc_compid, .f.)

  *-- Get GL company number
*\ [1 line] PTR# 71824 BAUG 02/03/04 Expand company ID to 10 characters

  lc_glcomp = a_sysdat->gllinkco

  *-- If "Release to GL" flag is already set
  IF SUBSTR(a_sysdat->str10, IIF(gc_applid = "PR", 6, 3), 1) = "Y" AND ;
     gl_multi

    *-- Unlock file and display alert
    go_SQL.cmpA_Sysdat.m_Unlock()
    DO g_dspalt WITH "Another user is releasing entries to General Ledger" + ;
                     gc_oseol + ;
                     "from this application.  " + ;
                     "Unable to release to GL.", 2

    *-- Set flag to cancel
    ll_cont = .f.
  ELSE

    *-- Flag not already set, so set flag and continue
    IF gc_applid = "PR"
      go_SQL.so_CurrentAlias.m_ReplaceBulk("str10 WITH " + ;
               "LEFT(a_sysdat->str10, 5) + 'Y' + SUBSTR(a_sysdat->str10, 7)")
    ELSE
      go_SQL.so_CurrentAlias.m_ReplaceBulk("str10 WITH " + ;
               "LEFT(a_sysdat->str10, 2) + 'Y' + SUBSTR(a_sysdat->str10, 4)")
    ENDIF

    *-- Set flag to remove flag from application SYSDATA record
    ll_flgsy = .t.
  ENDIF

  *-- If not cancelled
  IF ll_cont

    *-- Find GL record to check posting
    ln_glsys = g_setsys("GL", lc_glcomp, .f.)

    *-- If another user is posting
    IF a_sysdat->num10 > 0.00 AND gl_multi

      *-- Unlock file and display alert
      go_SQL.cmpA_Sysdat.m_Unlock()
      DO g_dspalt WITH "Another user is currently posting to GL company " + ;
                       lc_glcomp + ;
                       "." + ;
                       gc_oseol + ;
                       "Unable to release to GL.", 2

      *-- Set flag to cancel
      ll_cont = .f.
    ELSE
      *-- Flag not already set, so increment count of users posting in num10
      go_SQL.so_CurrentAlias.m_ReplaceBulk("num10 WITH " + ;
                                           "MAX(a_sysdat->num10 + 1, 1)")

      *-- Set flag to remove flag from GL SYSDATA record
      ll_flggl = .t.

    ENDIF && a_sysdat->num10 > 0.00

  ENDIF && ll_cont

  *-- Release lock on SYSDATA file
  go_SQL.cmpA_Sysdat.m_Unlock()
ENDIF && ll_cont

*-- If not cancelled
IF ll_cont
  *-- Check single user maintenance flag in target GL company
  ll_cont = c_flgda("GL", lc_glcomp, .t., gn_retry, 0)
ENDIF

*-- If not cancelled
IF ll_cont
  *-- Open files
  DO l_opskgl
ENDIF

*-- If not cancelled
IF ll_cont
  *-- Call routine to lock source files
  DO l_lckkgl WITH "SOURCE"
ENDIF

*-- If not cancelled (if locks succeeded)
IF ll_cont

  *-- Get last session to include
  lc_lastses = g_retact(4)

  *-- See if there are any unposted transactions in current dist. file
  go_SQL.m_TableChangeCurrent(lc_aldist)

  go_SQL.so_CurrentAlias.m_Seek(gx_false, "")

  lc_curcond = "" + lc_aldist + "." + gc_applid + "sess <= '" + lc_lastses + ;
               "' AND " + lc_aldist + ".posted = ??gx_false"

  ll_curr = .f.
  ln_curr = 0

  go_SQL.so_CurrentAlias.m_ScanBegin("F", lc_curcond)

  DO WHILE go_SQL.so_CurrentAlias.m_ScanBulk()
    *-- Save maximum record number currently in file

    *-- Since the call to other methods like m_GetRecno() inside the FOR/WHILE
    *-- conditions of methods like m_ScanBegin(), m_SetFilter(), m_copyto(),
    *-- etc., is not supported, instead of using "ln_curr" the condition used
    *-- to derive "ln_curr", i.e., "&lc_aldist.->&gc_applid.sess <= lc_lastses
    *-- AND NOT &lc_aldist.->posted" is stored in "lc_curcond" and used in the
    *-- places where "ln_curr" or its equivalent conditions were used. Same way
    *-- instead of "ln_hist", "lc_hiscond" is used.
    ln_curr = IIF(go_SQL.cmp&lc_Aldist..m_GetRecno() > ln_curr, ;
                go_SQL.cmp&lc_Aldist..m_GetRecno(), ln_curr)
    ll_curr = .t.
  ENDDO

  go_SQL.so_CurrentAlias.m_ScanEnd()

  *-- See if there are any unposted transactions in the history dist. file
  ll_hist = go_SQL.cmp&lc_Alydst..m_Seek(gx_false, "")

  *-- Save maximum record number currently in file
  ln_hist = IIF(ll_hist, go_SQL.cmp&lc_Alydst..m_Reccount(), 0)

  lc_hiscond = lc_alydst + ".posted = ??gx_false"

  *-- Release locks on xxDIST/xxYDST files
  go_SQL.cmp&lc_Aldist..m_Unlock()
  go_SQL.cmp&lc_Alydst..m_Unlock()

  *-- If no unposted transactions found in either file
  IF NOT (ll_curr OR ll_hist)
    *-- Display alert
    DO g_dspalt WITH "No unreleased entries found in distribution files." , 2

    *-- Set flag to cancel
    ll_cont = .f.
  ENDIF

ENDIF && ll_cont

*-- If not cancelled
IF ll_cont

  *-- Initialize ledger posting balance
  ln_bal = 0.00

  *-- Print posting register and calculate ledger posting balance
  DO l_prnkgl

  IF ll_cont AND ln_bal <> NTOM(0.00)
    *-- Out of balance, display alert
    lc_text1 = "This Ledger posting is not balanced (Credits <> Debits)."
    lc_text2 = "The posting is out of balance by $" + ;
               ALLTRIM(STR(ln_bal, 10, 2))

    lc_text3 = "A balancing entry will be posted to the Suspense Account"
    lc_text4 = "in this amount."
    lc_text5 = " "

    DO g_dspbx WITH 0, 0, 0, .t., lc_text1, lc_text2, lc_text3, lc_text4, ;
                    lc_text5, "", "", "", "", "", "", "", "", "", ""
  ENDIF

ENDIF

*-- If not cancelled
IF ll_cont

  *-- Confirm posting
  ll_cont = (g_getdlg("Ready to release entries as a " + ;
            IIF(lc_detail = "Y", "detail", "summary") + ;
            gc_oseol + ;
            "posting to the General Ledger?", 1, 2, "Proceed", ;
            "Cancel", "", "") = 1)
ENDIF

*-- If not cancelled
IF ll_cont

  *-- If unposted records in current file
  IF ll_curr
    *-- Call routine to validate GL account numbers
    DO l_valkgl WITH lc_aldist, ln_curr, lc_curcond
  ENDIF

  *-- If not cancelled and if unposted records in history file
  IF ll_cont AND ll_hist
    *-- Call routine to validate GL account numbers
    DO l_valkgl WITH lc_alydst, ln_hist, lc_hiscond
  ENDIF

ENDIF

*-- If not cancelled
IF ll_cont
  *-- Call routine to lock source files
  DO l_lckkgl WITH "SOURCE"
ENDIF

*-- If not cancelled
IF ll_cont
  *-- Call routine to lock GL destination files
  DO l_lckkgl WITH "DESTINATION"
ENDIF

*-- If not cancelled
IF ll_cont

  *-- If not cancelled and if unposted records in history file
  IF ll_hist
    *-- Call routine to do the index before transaction processing begins
    DO l_indkgl WITH lc_alydst, ln_hist, lc_hiscond, lc_histag

    *-- Close the non structural index before transaction processing starts
    go_SQL.cmp&lc_alydst..m_SetIndex()
  ENDIF

  *-- If not cancelled and if unposted records in current file
  IF ll_curr
    *-- Call routine to do the index before transaction processing begins
    DO l_indkgl WITH lc_aldist, ln_curr, lc_curcond, lc_currtag

    *-- Close the non structural index before transaction processing starts
    go_SQL.cmp&lc_aldist..m_SetIndex()
  ENDIF

  lo_Save = g_newobj("cntcallsylkgl", gc_idrvprg + "sybase.vcx")

  IF TYPE("lo_save.BaseClass") == "C"
    lo_Save.m_Run()
  ENDIF

  IF ll_hist
*\ [1 Line] PTR 75649 06/07/04 TIMI corrected the parameter of DROPINDEX command to delete 'idx' file
   go_SQL.m_DropIndex(,,,"F",lc_histag +".IDX", .t., .t.)
  ENDIF

  IF ll_curr
*\ [1 Line] PTR 75649 06/07/04 TIMI parameter of DROPINDEX command corrected to delete 'idx' file  
   go_SQL.m_DropIndex(,,,"F",lc_currtag +".IDX", .t., .t.)
  ENDIF

ENDIF

*-- If flags set in application or GL system record
IF ll_flgsy OR ll_flggl
  *-- Select SYSDATA
  go_SQL.m_TableChangeCurrent("a_sysdat")

  *-- Display processing message
  DO g_dspst WITH "Clearing system flags...", .t., gn_msgline, "", "", ""

  *-- If application flag set
  IF ll_flgsy
    *-- Find applicaiton record in SYSDATA
    go_SQL.cmpA_Sysdat.m_MoveToRecno(ln_rlsys)

    *-- Lock record in SYSDATA
    = (go_SQL.cmpA_Sysdat.m_LockRow(-1, .f.))

    *-- Clear lock in SYSDATA
    IF gc_applid = "PR"
      go_SQL.so_CurrentAlias.m_ReplaceBulk("str10 WITH " + ;
               "LEFT(a_sysdat->str10, 5) + 'N' + SUBSTR(a_sysdat->str10, 7)")
    ELSE
      go_SQL.so_CurrentAlias.m_ReplaceBulk("str10 WITH " + ;
               "LEFT(a_sysdat->str10, 2) + 'N' + SUBSTR(a_sysdat->str10, 4)")
    ENDIF

    *-- Release record lock
    go_SQL.cmpA_Sysdat.m_Unlock()
  ENDIF && ll_flgsy

  *-- If GL flag set
  IF ll_flggl
    *-- Find GL record in SYSDATA
    go_SQL.cmpA_Sysdat.m_MoveToRecno(ln_glsys)

    *-- Lock record in SYSDATA
    = (go_SQL.cmpA_Sysdat.m_LockRow(-1, .f.))

    *-- Decrement count of users
    go_SQL.so_CurrentAlias.m_ReplaceBulk("num10 WITH " + ;
                                         "MAX(a_sysdat->num10 - 1, 0)")

    *-- Release record lock
    go_SQL.cmpA_Sysdat.m_Unlock()
  ENDIF && ll_flggl

ENDIF && ll_flgsy OR ll_flggl

*-- Release locks on files
go_SQL.m_UnlockAll()

*-- Delete temporary picklist files
go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf1 + gc_extdbf, "", "F")
go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")
go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "", "F")

*\ [Begin] PTR# 74180 06/23/04 TIAI Fix for performance optimization
IF go_SQL.m_IsTableFound(lf_Stemp4)
  go_SQL.m_DropTable(lf_Stemp4)
ENDIF

IF go_SQL.m_IsTableFound(lf_Stemp5)
  go_SQL.m_DropTable(lf_Stemp5)
ENDIF
*\ [End] PTR# 74180 06/23/04 TIAI Fix for performance optimization

*-- Close open files
go_SQL.m_CloseTableAll()

*-- Open files
*# DOCCODE DO aropnf
*# DOCCODE DO aropnf
*# DOCCODE DO icopnf
*# DOCCODE DO propnf
DO (gc_adrvprg + gc_applid + "opnf") WITH .t.

*-- Clear messsage
DO g_dspst WITH gc_task, .f., gn_msgline, gc_applid, gc_compid, gc_userid

RETURN
*------------------------------------------------------------------------------
*- End Main: SYLKGL.PRG
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_LCKKGL
*------------------------------------------------------------------------------
*- Description: Lock source or destination files for release to GL
*------------------------------------------------------------------------------
*- Synopsis...: Lock source or destination files for release to GL
*------------------------------------------------------------------------------
*- Calls......: None
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: gc_applid, gc_compid, gc_idrvdbf
*-
*- Parameters.: lc_task, type of file set to lock/unlock, one of:
*-                       "SOURCE"      - lock xxDIST/xxYDST files
*-                       "DESTINATION" - lock GL files
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if unable to lock
*-
*- Parameters.: None
*-
*- Files Open.: For SOURCE:
*-                For AP lock:  APDIST, APYDST
*-                For AR lock:  ARDIST, ARYDST
*-                For IC lock:  ICDIST, ICYDST
*-
*-              For DESTINATION:
*-                Lock: GLBTCH, GLDUNP, GLHUNP
*------------------------------------------------------------------------------
*- Example:
*-   DO l_lckkgl WITH "SOURCE"
*------------------------------------------------------------------------------
PROCEDURE l_lckkgl

PARAMETERS lc_task

  *-- Attempt lock
  DO CASE
    CASE lc_task = "SOURCE"
      *-- Lock source files

      *-- Loop to acquire file lock on both xxDIST and xxYDST files
      ll_cont = .f.

      DO WHILE NOT ll_cont
        *-- Release locks to prevent deadlock on retries
        go_SQL.cmp&lc_Aldist..m_Unlock()
        go_SQL.cmp&lc_Alydst..m_Unlock()
        *-- Attempt file locks
        ll_cont = (go_SQL.cmp&lc_Aldist..m_LockFile(gn_retry, .f.)) AND ;
                  (go_SQL.cmp&lc_Alydst..m_LockFile(gn_retry, .f.))
      ENDDO

    CASE lc_task = "DESTINATION"
      *-- Lock GL destination files

      *-- Loop to acquire file lock on both xxDIST and xxYDST files
      ll_cont = .f.

      DO WHILE NOT ll_cont
        *-- Release locks to prevent deadlock on retries
        go_SQL.cmpA_Glbtch.m_Unlock()
        go_SQL.cmpA_Gldunp.m_Unlock()
        go_SQL.cmpA_Glhunp.m_Unlock()
        *-- Attempt file locks
        ll_cont = (go_SQL.cmpA_Glbtch.m_LockFile(gn_retry, .f.)) AND ;
                  (go_SQL.cmpA_Gldunp.m_LockFile(gn_retry, .f.)) AND ;
                  (go_SQL.cmpA_Glhunp.m_LockFile(gn_retry, .f.))
      ENDDO

  ENDCASE

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_lckgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_MRKKGL
*------------------------------------------------------------------------------
*- Description: Mark/unmark transaction records as posted
*------------------------------------------------------------------------------
*- Synopsis...: Mark transaction records as posted
*------------------------------------------------------------------------------
*- Calls......: G_DSPST
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: ll_curr, ln_curr, ll_hist, ln_hist
*-
*- Parameters.: ll_mark, if .t. mark records as posted
*-                       if .f., clear BATCH/GLBATCH field in unposted records
*-
*- Files Open.: Assumes xxDIST/xxYDST files are open and file locked.
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if error occurred
*-
*- Parameters.: None
*-
*- Files Open.: Leaves all files open.  Updates xxDIST/xxYDST files.
*------------------------------------------------------------------------------
*- Example:
*-   DO l_mrkkgl WITH ll_cont
*------------------------------------------------------------------------------
PROCEDURE l_mrkkgl

PARAMETERS ll_mark

  *-- If marking records
  IF ll_mark
    *-- Display processing message
    DO g_dspst WITH "Marking transaction records as released...", .t., ;
                    gn_msgline, "", "", ""

    *-- Mark unposted records in xxDIST file
    go_SQL.m_TableChangeCurrent(lc_aldist)
    go_SQL.cmp&lc_Aldist..m_SetOrder(0)

    go_SQL.so_CurrentAlias.m_ReplaceBulk("posted WITH ??gx_true", ;
                                         "F", ;
                                         lc_curcond, ;
                                         .t.)

    *-- Mark unposted records in xxYDST file
    go_SQL.m_TableChangeCurrent(lc_alydst)
    go_SQL.cmp&lc_Alydst..m_SetOrder(0)

    go_SQL.so_CurrentAlias.m_ReplaceBulk("posted WITH ??gx_true", ;
                                         "F", ;
                                         lc_hiscond, ;
                                         .t.)

  ELSE
    *-- If not marking records

    *-- Display processing message
    DO g_dspst WITH "Clearing batch numbers from transaction records...", ;
                    .t., gn_msgline, "", "", ""

    *-- Clear GL batch number from unposted records in xxDIST file
    go_SQL.m_TableChangeCurrent(lc_aldist)
    go_SQL.so_CurrentAlias.m_Seek(gx_false, "")

    go_SQL.so_CurrentAlias.m_ReplaceBulk(IIF(gc_applid = "PR", ;
                     "batch WITH '', glcomp WITH ''", ;
                     "glbatch WITH '', glcomp WITH ''"), ;
                     "F", lc_curcond, .t.)

    *-- Clear GL batch number from unposted records in xxYDST file
    go_SQL.m_TableChangeCurrent(lc_alydst)
    go_SQL.so_CurrentAlias.m_Seek(gx_false, "")

    go_SQL.so_CurrentAlias.m_ReplaceBulk(IIF(gc_applid = "PR", ;
                     "batch WITH '', glcomp WITH ''", ;
                     "glbatch WITH '', glcomp WITH ''"), ;
                     "F", lc_hiscond, .t.)

  ENDIF && ll_mark

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_mrkkgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_PSTKGL
*------------------------------------------------------------------------------
*- Description: Load temporary GL files from transaction file
*------------------------------------------------------------------------------
*- Synopsis...: Load temporary GL files from transaction file
*------------------------------------------------------------------------------
*- Calls......: G_DSPALT, G_DSPST, G_GETGLB(), G_GETGLT()
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: lc_glcomp, lc_detail, lc_suspen, lc_alcash, lc_alycsh,
*-              lc_altran, lc_alytrn
*-
*- Parameters.: lc_alias,   source file alias
*-              ln_maxrec,  maximum record number to be processed in
*-                          source file
*-              lc_cond,    validatation for current/history files
*-              ll_NotHist, Indicates whether this procedure is called to
*-                          process History or Current file
*-
*- Files Open.: Assumes source xxDIST/xxYDST and destination GLBTCH,
*-              GLDUNP, and GLHUNP files are open and all file locked.
*-
*-              Assumes the following files are open:
*-
*-              For AP:  APDIST, APYDST
*-              For AR:  ARCASH, ARDIST, ARTRAN, ARYCSH, ARYDST, ARYTRN
*-              For IC:  ICDIST, ICTRAN, ICYDST, ICYTRN
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if error occurred
*-
*- Parameters.: None
*-
*- Files Open.: Leaves all files open.  Adds records to destination GL
*-              files. Update source xxDIST/xxYDST file with generated GL
*-              batch numbers.
*------------------------------------------------------------------------------
*- Example:
*-   DO l_pstkgl WITH lc_aldist, ln_curr, lc_cond, .t.
*------------------------------------------------------------------------------
PROCEDURE l_pstkgl

PARAMETERS lc_alias, ;
           ln_maxrec, ;
           lc_cond, ;
           ll_NotHist

*\ [1 Line] PTR# 74180 06/22/04 TIAI Fix for performance optimization
*\ [1 Line] PTR# 78127 01/13/05 TISP Declared private variable ld_LstTranDte
  PRIVATE lc_docexp, ;
          lc_sumexp, ;
          lc_ndxexp, ;
          lc_yearprd, ;
          lc_batchno, ;
          lc_sess, ;
          la_sess, ;
          ln_sesscnt, ;
          ln_sess, ;
          ld_gldate, ;
          lc_tranno, ;
          ln_tdrtot, ;
          ln_tcrtot, ;
          ln_bdrtot, ;
          ln_bcrtot, ;
          lc_gltdes, ;
          ln_amount, ;
          lc_glacnt, ;
          lc_dockey, ;
          lc_subdetl, ;
          lc_alias1, ;
          lc_revper, ;
          lc_revyear, ;
          lc_trantype, ;
          ld_LstTranDte

  *-- Set alias names that has to be used for original tables
  DO CASE
    CASE lc_alias = "a_ardist"
      lc_alias1 = "a_ardis1"
    CASE lc_alias = "a_arydst"
      lc_alias1 = "a_aryds1"
    CASE lc_alias = "a_apdist"
      lc_alias1 = "a_apdis1"
    CASE lc_alias = "a_apydst"
      lc_alias1 = "a_apyds1"
    CASE lc_alias = "a_icdist"
      lc_alias1 = "a_icdis1"
    CASE lc_alias = "a_icydst"
      lc_alias1 = "a_icyds1"
    CASE lc_alias = "a_prdist"
      lc_alias1 = "a_prdis1"
    CASE lc_alias = "a_prydst"
      lc_alias1 = "a_pryds1"
  ENDCASE

  *-- Set index order in chart of accounts file
  go_SQL.cmpA_Glacnt.m_SetOrder("glacnt")

  *-- Initialize array to hold session numbers
  DECLARE la_sess[1]
  la_sess[1] = ""
  ln_sesscnt = 0

  *-- Setup summarization and index key expressions
  DO CASE
*/ [6 lines] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
    CASE (gc_applid = "AP" OR gc_applid = "AR") AND lc_detail = "N"
      *-- Summary
      lc_sumexp = [.t.]
      lc_ndxexp = [glfyear + glper + trantype + glacnt]
      lc_docexp = [""]
      lc_dockey = ""

    CASE lc_detail = "N"
      *-- Summary
      lc_sumexp = [.t.]
      lc_ndxexp = [glfyear + glper + glacnt]
      lc_docexp = [""]
      lc_dockey = ""

    CASE gc_applid = "AP" AND lc_detail = "Y"
      *-- Accounts Payable, Detail
      lc_sumexp = lc_alias + [->dttype = "P"]
*/ [1 line] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
      lc_ndxexp = [glfyear + glper + trantype + apsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      *-- Set expression for document number lookup
      lc_docexp = lc_alias + [->vendno + ] + lc_alias + [->invno]

    CASE gc_applid = "AR" AND lc_detail = "Y"
      *-- Accounts Receivable, Detail
      lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
*/ [1 line] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
      lc_ndxexp = [glfyear + glper + trantype + arsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      lc_docexp = [custno + invno]

    CASE gc_applid = "IC" AND lc_detail = "Y"
      *-- Inventory Control, Detail
      lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
      lc_ndxexp = [glfyear + glper + icsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]


      lc_docexp = [applid + docno]

    CASE gc_applid = "PR" AND lc_detail = "Y"
      *-- PayrollControl, Detail
      lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
      lc_ndxexp = [glfyear + glper + icsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)

      lc_sumexp = [LEFT(] + lc_alias + [->dsttype,1) = "C"]
      lc_ndxexp = [glfyear + glper + prsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      *-- Set expression for document number lookup
      lc_docexp = lc_alias + [->checkno]
  ENDCASE

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
  lc_trantype = IIF(gc_applid = "AP" OR gc_applid = "AR", lc_alias + [->trantype], [''])

  go_SQL.cmpA_gldunp.m_CopyStructure(lf_Stemp10)
  = g_opnfl(lf_Stemp10, "a_tmpf10", .t., .f., "", .f.)

  go_SQL.m_TableChangeCurrent(lc_alias)

  *-- Check whether Current or History file and set index accordingly
  go_SQL.cmp&lc_alias..m_SetIndex(IIF(ll_NotHist, lc_currtag, lc_histag))

  GO TOP
  ln_marker  = 1
  lc_glfyear = glfyear
  lc_glper   = glper
  lc_trntyp  = &lc_trantype
  lc_glacnt  = glacnt
  lc_sess    = &gc_applid.sess

  IF lc_detail = "N" 

    SCAN WHILE NOT EOF()
*\ [1 Line] PTR# 74180_1 07/14/04 TIAI Excluded sessno from the condition
*\ [1 Line] PTR# 78136 11/12/04 SSHA Mark revaluation records separately
      IF glfyear <> lc_glfyear OR ;
         glper <> lc_glper OR ;
         glacnt <> lc_glacnt OR ;
         NOT &lc_sumexp OR ;
         ( (gc_applid = "AP" OR gc_applid = "AR") AND TranType <> lc_trntyp AND TranType = 'R')
         

        ln_marker  = ln_marker + 1
        lc_glfyear = glfyear
        lc_glper   = glper
        lc_trntyp  = &lc_trantype
        lc_glacnt  = glacnt
*\ [1 Line] PTR# 74180_1 07/14/04 TIAI sessno not needed for summary posting
*!*	        lc_sess    = &gc_applid.sess
      ENDIF

*\ [1 Line] PTR# 78136 11/12/04 SSHA Mark revaluation records separately
      IF gc_applid = "AP" OR gc_applid = "AR"
        REPLACE marker WITH ln_marker, ;
              TranType WITH IIF(TranType = 'R', 'R', "")
      ELSE
        REPLACE marker WITH ln_marker
      ENDIF
              
    ENDSCAN

  ELSE
    lc_dockey  = &lc_docexp

    SCAN WHILE NOT EOF()
      IF glfyear <> lc_glfyear OR glper <> lc_glper OR &lc_trantype <> lc_trntyp OR ;
        glacnt <> lc_glacnt OR &gc_applid.sess <> lc_sess OR &lc_docexp <> lc_dockey
        ln_marker  = ln_marker + 1
        lc_glfyear = glfyear
        lc_glper   = glper
        lc_trntyp  = &lc_trantype
        lc_glacnt  = glacnt
        lc_sess    = &gc_applid.sess
        lc_dockey  = &lc_docexp
      ENDIF

      REPLACE marker WITH ln_marker
    ENDSCAN

  ENDIF

  go_SQL.m_SQLSelect("MAX(glfyear) as glfyear, " + ;
         "MAX(glper) AS glper, " + ;
         "MAX(&lc_trantype) AS trantype, " + ;
         "MAX(glacnt) AS glacnt, " + ;
         "MAX(" + gc_applid + "sess) AS '" + gc_applid + "sess', " + ;
         "SUM(amount) AS amount1 , " + ;
         "MAX(0000000000000000.0000) AS gldamnt, " + ;
         "MAX(0000000000000000.0000) AS glcamnt, " + ;
         "MAX(0000000000000000.0000) AS fgdamnt, " + ;
         "MAX(0000000000000000.0000) AS fgcamnt, " + ;
         "MAX(??gx_True) AS credit, " + ;
         "MAX(SPACE(" + STR(FSIZE("BATCHNO", "a_gldunp")) + ")) AS batchno, " + ;
         "MAX(SPACE(" + STR(FSIZE("GLSEQNO", "a_gldunp")) + ")) AS glseqno, " + ;
         "MAX(gltdes) AS gltdes, " + ;
         "MAX(subdetl) AS subdetl, " + ;
         "MAX(0000) AS tranlineno, " + ;
         "MAX(SPACE(" + STR(FSIZE("SUBCODE", "a_gldunp")) + ")) AS subcode, " + ;
         "MAX(SPACE(" + STR(FSIZE("PHASE", "a_gldunp")) + ")) AS phase, " + ;
         "MAX(SPACE(" + STR(FSIZE("JOBCODE", "a_gldunp")) + ")) AS jobcode, " + ;
         "MAX(gc_userid) AS adduser, " + ;
         "MAX(gd_sdate) AS adddate, " + ;
         "MAX(TIME()) AS addtime, " + ;
         "MAX('') AS lckstat, " + ;
         "MAX(gc_userid) AS lckuser, " + ;
         "MAX(gd_sdate) AS lckdate, " + ;
         "MAX(TIME()) AS lcktime " +  ;
         " FROM " + go_SQL.cmp&lc_alias..sc_tableNameFull + " " + lc_alias + ;
         " GROUP BY marker", ;
         "TABLE", ;
         lf_Ftemp9, "F")

  go_SQl.so_Currentalias.m_CloseTable()
  = g_opnfl(lf_Ftemp9, "a_tmpf9", .t., .f., "", .f., "F")

  REPLACE ALL gldamnt WITH IIF(amount1 < 0, 0, ABS(amount1)), ;
              glcamnt WITH IIF(amount1 < 0, ABS(amount1), 0), ;
              fgdamnt WITH IIF(amount1 < 0, 0, ABS(amount1)), ;
              fgcamnt WITH IIF(amount1 < 0, ABS(amount1), 0), ;
              credit  WITH IIF(amount1 < 0, .t., .f.)

  lc_Expr = IIF(gc_applid <> "PR", "glbatch", "batch")

  go_SQL.m_TableChangeCurrent(lc_alias)

  *-- Post to GL files
  GO TOP
  DO WHILE NOT EOF()
    *-- Save year period number for batch
*/ [3 lines] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
    lc_yearprd = &lc_alias.->glfyear + &lc_alias.->glper + ;
                    IIF(gc_applid = "AP" OR gc_applid = "AR", ;
                    &lc_alias.->trantype, "")

    *-- Get batch number
    lc_batchno = g_getglb(lc_glcomp)

    *-- Display processing message
    DO g_dspst WITH "Creating batch " + ALLTRIM(lc_batchno) + " " + ;
                    LEFT(lc_yearprd, 4) + "/" + RIGHT(lc_yearprd, 2) + ;
                    "...", .t., gn_msgline, "", "", ""

    *-- Setup accumulator variables for batch
    ln_bdrtot = 0
    ln_bcrtot = 0
    lc_lowseq = SPACE(6)
    lc_uppseq = SPACE(6)

    *-- Process records for batch
    go_SQL.m_TableChangeCurrent(lc_alias)

*/ [4 lines] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
    DO WHILE &lc_alias.->glfyear + &lc_alias.->glper + ;
          IIF(gc_applid = "AP" OR gc_applid = "AR", ;
          &lc_alias->trantype, "") = lc_yearprd ;
          AND NOT EOF()

      *-- Setup session ID and date field values for GLHUNP update
      lc_sess   = IIF(lc_detail = "Y", &lc_alias.->&gc_applid.sess, "")
      ld_gldate = &lc_alias.->trandte

*\ [1 Line] PTR# 78127 01/13/05 TISP Initialized ld_LstTranDte
      ld_LstTranDte = &lc_alias.->trandte

      *-- Get transaction number
      lc_tranno = g_getglt(lc_glcomp)

      *-- Update upper and lower transaction numbers for batch record
      lc_lowseq = IIF(EMPTY(lc_lowseq), lc_tranno, MIN(lc_tranno, lc_lowseq))
      lc_uppseq = MAX(lc_tranno, lc_uppseq)

      *-- Setup accumulator variables for batch
      ln_tdrtot = 0
      ln_tcrtot = 0

*/ [19 lines] PTR# 41177 SOCO 04/28/04 Determine reversing period & year.
      *-- Set reversing period and year.
      lc_revper  = ""
      lc_revyear = ""
      IF gc_applid = "AP" OR gc_applid = "AR"
        IF &lc_alias.->glper = STR(gn_fcprds, 2, 0)
          *-- If the posting period is the last fiscal period
          *-- then set the reversal period to '01'
          lc_revper  = "01"
          *-- Set the reversal year to the current fiscal year + 1
          lc_revyear = ALLTRIM(STR(VAL(&lc_alias.->glfyear) + 1, 4, 0))
        ELSE
          *-- If the posting period is not the last fiscal period, then set
          *-- reversal period to transaction period + 1
          lc_revper  = PADL(ALLTRIM(STR(VAL(&lc_alias.->glper) + 1, 2, 0)), 2, "0")
          *-- Set the reversal year to the posting year
          lc_revyear = &lc_alias.->glfyear
        ENDIF
      ENDIF

      *-- Add transaction header record to GLHUNP
      go_SQL.m_TableChangeCurrent("a_glhunp")
*\ [1 line] PTR # 60438 06/28/04 TIRS Changed code to display system date as date for GL
*/ [8 lines] PTR# 41177 SOCO 04/28/04 Add Reversing Entry info.
      go_SQL.cmpA_Glhunp.m_SQLInsert("batchno, " + ;
                    "glseqno, " + ;
                    "subno, " + ;
                    "gltdes, " + ;
                    "glrefr, " + ;
                    "gldate, " + ;
                    "yearprd, " + ;
                    "status, " + ;
                    "trtype, " + ;
                    "glmodule, " + ;
                    "glcomp, " + ;
                    "glrevrs, " + ;
                    "revper, " + ;
                    "revyear, " + ;
                    "adduser, " + ;
                    "adddate, " + ;
                    "addtime, " + ;
                    "lckstat, " + ;
                    "lckuser, " + ;
                    "lckdate, " + ;
                    "lcktime", ;
                    "'" + lc_batchno + "', " + ;
                    "'" + lc_tranno + "', " + ;
                    "'" + lc_sess + "', " + ;
                    "'Posting from " + gc_applid + ", " + gc_compid + "', " + ;
                    "'', " + ;
                    "gd_sdate, " + ;
                    "'" + lc_yearprd + "', " + ;
                    "'U', " + ;
                    "'Z', " + ;
                    "'" + gc_applid + "', " + ;
                    "'" + gc_compid + "', " + ;
                    IIF((gc_applid = "AP" OR gc_applid = "AR") ;
                      AND &lc_alias.->trantype = "R", "'Y', ", "'N', ") + ;
                    IIF((gc_applid = "AP" OR gc_applid = "AR") ;
                      AND &lc_alias.->trantype = "R", ;
                      "'" + lc_revper + "', ", "'', ") + ;
                    IIF((gc_applid = "AP" OR gc_applid = "AR") ;
                      AND &lc_alias.->trantype = "R", ;
                      "'" + lc_revyear + "', ", "'', ") + ;
                    "gc_userid, " + ;
                    "gd_sdate, " + ;
                    "TIME(), " + ;
                    "'', " + ;
                    "gc_userid, " + ;
                    "gd_sdate, " + ;
                    "TIME()", ;
                    "")

      *-- Process records for transaction
      go_SQL.m_TableChangeCurrent(lc_alias)

*\ [Begin] PTR# 74180_1 07/14/04 TIAI Excluded sessno for summary posting
      IF lc_detail = "N" 
        LOCATE FOR glfyear + glper + &lc_trantype > lc_yearprd ;
               WHILE glfyear + glper + &lc_trantype = lc_yearprd AND l_replace(lc_Expr)

        go_SQL.m_TableChangeCurrent("a_tmpf9")
*\ [1 Line] PTR# 78136 11/12/04 SSHA Mark revaluation records separately
        REPLACE ALL batchno WITH lc_batchno, ;
                    glseqno WITH lc_tranno, ;
                    adduser WITH gc_userid, ;
                    adddate WITH gd_sdate, ;
                    addtime WITH TIME(), ;
                    lckstat WITH '', ;
                    lckuser WITH gc_userid, ;
                    lckdate WITH gd_sdate, ;
                    lcktime WITH TIME() FOR glfyear + glper + TranType =  lc_yearprd  
      ELSE
        LOCATE FOR glfyear + glper + &lc_trantype + &gc_applid.sess > lc_yearprd + lc_sess ;
               WHILE glfyear + glper + &lc_trantype + &gc_applid.sess = lc_yearprd + lc_sess AND l_replace(lc_Expr)

        go_SQL.m_TableChangeCurrent("a_tmpf9")
*\ [1 Line] PTR# 78136 11/12/04 SSHA Mark revaluation records separately
*\ [1 Line] PTR# 78293 12/12/04 SSHA Mark revaluation records separately
        REPLACE ALL batchno WITH lc_batchno, ;
                    glseqno WITH lc_tranno, ;
                    adduser WITH gc_userid, ;
                    adddate WITH gd_sdate, ;
                    addtime WITH TIME(), ;
                    lckstat WITH '', ;
                    lckuser WITH gc_userid, ;
                    lckdate WITH gd_sdate, ;
                    lcktime WITH TIME() ;
                    FOR glfyear + glper + IIF(gc_applid = "AP" OR gc_applid = "AR", trantype, "") + &gc_applid.sess = ;
                        lc_yearprd + lc_sess 
      ENDIF
*\ [End] PTR# 74180_1 07/14/04 TIAI Excluded sessno for summary posting

*\ [1 Line] PTR# 78127 01/13/05 TISP Update gldate with last transaction date
      go_SQL.cmpA_Glhunp.m_Replace("gldate", ld_LstTranDte)

*\ [2 Lines] PTR# 74180_1 07/14/04 TIAI Use only tranno in the FOR clause
      *-- Sum transaction debit and credit totals
      SUM gldamnt, glcamnt TO ln_tdrtot, ln_tcrtot FOR glseqno = lc_tranno

      ln_bdrtot = ln_bdrtot + ln_tdrtot
      ln_bcrtot = ln_bcrtot + ln_tcrtot

      *-- If transaction is out of balance
      IF ln_tdrtot <> ln_tcrtot
        *-- Setup out of balance amount
        ln_amount = ln_tcrtot - ln_tdrtot

        *-- Display alert
        DO g_dspalt WITH "Batch " + ALLTRIM(lc_batchno) + ;
                         " is out of balance by $ " + ;
                         LTRIM(STR(ln_amount, 10, 2)) + ".  An" + gc_oseol + ;
                         "offsetting amount posted to account " + ;
                         ALLTRIM(lc_suspen), 3

*\ [1 Line] PTR# 80089 08/12/05 TIVK Added subdetl,subcode,phase,jobcode,tranlineno fields
*\                                   to avoid storing null values
        *-- Add suspense transaction detail record to GLDUNP
        go_SQL.cmpA_tmpf10.m_SQLInsert("glacnt, " + ;
                          "batchno, " + ;
                          "glseqno, " + ;
                          "gltdes, " + ;
                          "gldamnt, " + ;
                          "glcamnt, " + ;
                          "credit, " + ;
                          "subdetl, " + ;
                          "subcode, " + ;
                          "phase, " + ;
                          "jobcode, " + ;
                          "tranlineno, " + ;
                          "adduser, " + ;
                          "adddate, " + ;
                          "addtime, " + ;
                          "lckstat, " + ;
                          "lckuser, " + ;
                          "lckdate, " + ;
                          "lcktime, " + ;
                          "fgdamnt, " + ;
                          "fgcamnt", ;
                          "lc_suspen, " + ;
                          "lc_batchno, " + ;
                          "lc_tranno, " + ;
                          "'Suspense - Out of Balance', " + ;
                          "IIF(ln_amount < 0, 0, ABS(ln_amount)), " + ;
                          "IIF(ln_amount < 0, ABS(ln_amount), 0), " + ;
                          "IIF(ln_amount < 0, gx_True, gx_False), " + ;
                          "'', " + ;
                          "'', " + ;
                          "'', " + ;
                          "'', " + ;
                          "0, " + ;
                          "gc_userid, " + ;
                          "gd_sdate, " + ;
                          "TIME(), " + ;
                          "'', " + ;
                          "gc_userid, " + ;
                          "gd_sdate, " + ;
                          "TIME(), " + ;
                          "IIF(ln_amount < 0, 0, ABS(ln_amount)), " + ;
                          "IIF(ln_amount < 0, ABS(ln_amount), 0)", ;
                          "")

        *-- Update debit and credit totals for batch
        ln_bdrtot = ln_bdrtot + a_tmpf10->gldamnt
        ln_bcrtot = ln_bcrtot + a_tmpf10->glcamnt
      ENDIF && ln_tdrtot <> ln_tcrtot

      go_SQL.m_TableChangeCurrent(lc_alias)

    ENDDO && WHILE &lc_alias.->glfyear + &lc_alias.->glper = etc.

    *-- Update batch status record with totals for batch
    go_SQL.cmpA_Glbtch.m_SQLInsert("batchno, " + ;
                    "bdesc, " + ;
                    "yearprd, " + ;
                    "bref, " + ;
                    "lowseq, " + ;
                    "uppseq, " + ;
                    "btype, " + ;
                    "bstat, " + ;
                    "ctrltot, " + ;
                    "drtotal, " + ;
                    "crtotal, " + ;
                    "stsuser, " + ;
                    "stsdate, " + ;
                    "ststime, " + ;
                    "edtuser, " + ;
                    "edtdate, " + ;
                    "edttime, " + ;
                    "auduser, " + ;
                    "auddate, " + ;
                    "audtime, " + ;
                    "pstuser, " + ;
                    "pstdate, " + ;
                    "psttime, " + ;
                    "post1, " + ;
                    "post2, " + ;
                    "post3, " + ;
                    "post4, " + ;
                    "post5, " + ;
                    "post6, " + ;
                    "post7, " + ;
                    "post8, " + ;
                    "adduser, " + ;
                    "adddate, " + ;
                    "addtime, " + ;
                    "lckstat, " + ;
                    "lckuser, " + ;
                    "lckdate, " + ;
                    "lcktime, " + ;
                    "fgcrtotal, " + ;
                    "fgdrtotal, " + ;
                    "exchrat, " + ;
                    "currid", ;
                    "'" + lc_batchno + "', " + ;
                    "'Posting from " + gc_applid + ", " + gc_compid + "', " + ;
                    "'" + lc_yearprd + "', " + ;
                    "'', " + ;
                    "'" + lc_lowseq + "', " + ;
                    "'" + lc_uppseq + "', " + ;
                    "'Z', " + ;
                    "'U', " + ;
                    "MIN(ln_bdrtot, ln_bcrtot), " + ;
                    "ln_bdrtot, " + ;
                    "ln_bcrtot, " + ;
                    "gc_userid, " + ;
                    "gd_sdate, " + ;
                    "TIME(), " + ;
                    "'', " + ;
                    "CTOT(''), " + ;
                    "'', " + ;
                    "'', " + ;
                    "CTOT(''), " + ;
                    "'', " + ;
                    "'', " + ;
                    "CTOT(''), " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "'', " + ;
                    "gc_userid, " + ;
                    "gd_sdate, " + ;
                    "TIME(), " + ;
                    "'', " + ;
                    "gc_userid, " + ;
                    "gd_sdate, " + ;
                    "TIME(), " + ;
                    "ln_bcrtot, " + ;
                    "ln_bdrtot, " + ;
                    "1, " + ;
                    "gc_basecur", ;
                    "")

    go_SQL.m_TableChangeCurrent(lc_alias)
  ENDDO && WHILE NOT EOF()

  IF go_SQL.sc_SQLTypeMain <> "F"
    go_SQL.cmpA_tmpf10.m_AppendFrom(lf_Ftemp9)

*\ [1 Line] PTR# 78103 11/05/04 TINP Conditonally included 'pa' module related fields
*\ [2 Lines] PTR# 74903 07/16/04 TIAU Included column names to the target table
    *-- Add detail records in GLDUNP
    lc_SQLString = "INSERT INTO " + go_SQL.cmpA_Gldunp.sc_TableNameFull + " " + ;
                   "(batchno, glseqno, glacnt, gltdes, gldamnt, glcamnt, credit, " + ;
                   "subdetl, adduser, adddate, addtime, lckstat, lckuser, lckdate, " + ;
                   "lcktime, " + IIF(gl_laheypa, "subcode, phase, jobcode, ","") + ;
                   "fgcamnt, fgdamnt, tranlineno) (SELECT batchno, glseqno, glacnt, " + ;
                   "gltdes, gldamnt, glcamnt, credit, subdetl, adduser, adddate, " + ;
                   "addtime, lckstat, lckuser, lckdate, lcktime, " + ;
                   IIF(gl_laheypa, "subcode, phase, jobcode, ","") + "fgcamnt, fgdamnt, " + ;
                   "tranlineno FROM " + go_SQL.cmpA_tmpf10.sc_TableNameFull + ")"

    *-- Issue insert command
    go_SQL.m_Execute(lc_SQLString)
  ELSE
    SELECT a_gldunp
*\ [1 Line] PTR# 78164 11/12/04 TIVK Append from tmpf10 for any OOB record
    APPEND FROM (lf_Stemp10)
    APPEND FROM (lf_Ftemp9)
  ENDIF

*\ [1 Line] PTR# 79246 05/09/05 TIGJ Included the field glper
  go_SQL.m_SqlSelect("DISTINCT " + gc_applid + "sess AS sessno, " + ;
                     "glper, " + lc_Expr + " AS batchno " + ;
                     " FROM " + go_Sql.cmp&lc_alias..sc_tablenamefull + " " + lc_alias, ;
                     "TABLE", lf_Ftemp7, "F")

  go_SQl.so_Currentalias.m_CloseTable()
  = g_opnfl(lf_Ftemp7, "a_tmpf7", .t., .f., "", .f., "F")

  go_SQL.cmpA_tmpf7.m_CopyTo(lf_Stemp8, , "S")

  IF go_SQL.sc_SQLTypeMain <> "F"
*\ [1 Line] PTR# 76291 07/07/04 TIAI Added WHERE clause
*\ [1 Line] PTR# 79246 05/09/05 TIGJ Included glper in join condition
     go_SQL.m_Execute("UPDATE " + go_SQL.cmp&lc_alias1..sc_TableNameFull + ;
                      " SET " + lc_Expr + " = a_tmpf8.batchno, glcomp = '" + lc_glcomp + "' FROM " + ;
                       go_SQL.cmp&lc_alias1..sc_TableNameFull + " " + lc_alias1 + ;
                       " LEFT OUTER JOIN " + ;
                       lf_Stemp8 + " a_tmpf8" + ;
                       " ON " + lc_alias1 + "." + gc_applid + "sess = a_tmpf8.sessno " + ;
                       " AND " + lc_alias1 + "." + "glper = a_tmpf8.glper " + ;
                       "WHERE " + STRTRAN(lc_cond, lc_alias, lc_alias1))

*\ [1 Line] PTR# 76590 07/15/04 TIAI Added WHERE clause
      go_SQL.m_Execute("UPDATE " + go_SQL.cmpa_syuses.sc_TableNameFull + ;
                        " SET glbatch = a_tmpf8.batchno FROM " + ;
                        go_SQL.cmpa_syuses.sc_TableNameFull + " a_syuses " + ;
                        " LEFT OUTER JOIN " + ;
                        lf_Stemp8 + " a_tmpf8" + ;
                        " ON a_syuses.usession = a_tmpf8.sessno " + ;
                        "WHERE a_syuses.scompid + a_syuses.sapplid + a_syuses.usession = '" + gc_compid + gc_applid + "' + a_tmpf8.sessno")

*\ [1 Line] PTR# 76590 07/15/04 TIAI Added WHERE clause
       go_SQL.m_Execute("UPDATE " + go_SQL.cmpA_Syuyse.sc_TableNameFull + ;
                        " SET glbatch = a_tmpf8.batchno FROM " + ;
                        go_SQL.cmpA_Syuyse.sc_TableNameFull + " A_Syuyse " + ;
                        " LEFT OUTER JOIN " + ;
                        lf_Stemp8 + " a_tmpf8" + ;
                        " ON A_Syuyse.usession = a_tmpf8.sessno " + ;
                        "WHERE a_syuyse.scompid + a_syuyse.sapplid + a_syuyse.usession = '" + gc_compid + gc_applid + "' + a_tmpf8.sessno")

  ELSE
    g_opnfl(lf_Stemp8, "a_tmpf8", .t., .f., "", .f., "F")
*\ [1 Line] PTR# 79246 05/09/05 TIGJ Included glper in the index
    go_SQL.cmpA_tmpf8.m_CreateIndex("sessno", "sessno + glper", "", .t., .f.)
    go_SQL.cmpA_tmpf8.m_setorder("sessno")
  
*\ [1 Line] PTR# 79246 05/09/05 TIGJ Included glper in the relation
    go_SQL.cmp&lc_alias1..m_SetRelation(gc_applid + "sess + glper", "a_tmpf8", .f.)

*\ [1 Line] PTR# 76291 07/07/04 TIAI Added FOR condition
    go_SQL.cmp&lc_alias1..m_Replacebulk("&lc_Expr WITH a_tmpf8.batchno, " + ;
                                        "glcomp WITH lc_glcomp", ;
                                        "F", STRTRAN(lc_cond, lc_alias, lc_alias1), .t.)

    go_SQL.cmpA_syuses.m_SetRelation("usession", "a_tmpf8", .f.)
    go_SQL.cmpA_syuyse.m_SetRelation("usession", "a_tmpf8", .f.)

*\ [Begin] PTR# 76590 07/15/04 TIAI Added FOR condition
    go_SQL.cmpA_syuses.m_Replacebulk("glbatch WITH a_tmpf8.batchno", ;
                                      "F","a_syuses.scompid + a_syuses.sapplid + a_syuses.usession = gc_compid + gc_applid + a_tmpf8.sessno" , .t.)
    go_SQL.cmpA_syuyse.m_Replacebulk("glbatch WITH a_tmpf8.batchno", ;
                                      "F","a_syuyse.scompid + a_syuyse.sapplid + a_syuyse.usession = gc_compid + gc_applid + a_tmpf8.sessno" , .t.)
*\ [End] PTR# 76590 07/15/04 TIAI Added FOR condition
  ENDIF

  go_SQL.m_DropTable(lf_Ftemp7, , "F")
  go_SQL.m_DropTable(lf_Stemp8)
  go_SQL.m_DropTable(lf_Ftemp9, , "F")
  go_SQL.m_DropTable(lf_Stemp10)

*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

  *-- Close the temporary table that is opened in the alias name of the
  *-- original table
  go_SQL.cmp&lc_Alias..m_CloseTable()

  *-- Close the main table that is opened in different alias
  go_SQL.cmp&lc_Alias1..m_CloseTable()

  *-- Open the main table by its original alias
  DO CASE
    CASE gc_applid = "PR" AND lc_alias = "a_prdist"
      = g_opnfl(gf_prdistf, "a_prdist", .f., .f., "posted")

    CASE gc_applid = "PR" AND lc_alias = "a_prydst"
      = g_opnfl(gf_prydstf, "a_prydst", .f., .f., "posted")

    CASE gc_applid = "AR" AND lc_alias = "a_ardist"
      = g_opnfl(gf_ardistf, "a_ardist", .f., .f., "posted")

    CASE gc_applid = "AR" AND lc_alias = "a_arydst"
      = g_opnfl(gf_arydstf, "a_arydst", .f., .f., "posted")

    CASE gc_applid = "AP" AND lc_alias = "a_apdist"
      = g_opnfl(gf_apdistf, "a_apdist", .f., .f., "posted")

    CASE gc_applid = "AP" AND lc_alias = "a_apydst"
      = g_opnfl(gf_apydstf, "a_apydst", .f., .f., "posted")

    CASE gc_applid = "IC" AND lc_alias = "a_icdist"
      = g_opnfl(gf_icdistf, "a_icdist", .f., .f., "posted")

    CASE gc_applid = "IC" AND lc_alias = "a_icydst"
      = g_opnfl(gf_icydstf, "a_icydst", .f., .f., "posted")

  ENDCASE

  *-- Clear relation and remove temporary index
  go_SQL.m_TableChangeCurrent(lc_alias)
  go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)
  SET INDEX TO
  go_SQL.cmp&lc_Alias..m_SetOrder("posted")

  *-- Clear messsage
  DO g_dspst WITH gc_task, .f., gn_msgline, gc_applid, gc_compid, gc_userid

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_pstkgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_OPSKGL
*------------------------------------------------------------------------------
*- Description: Opens files for release to GL
*------------------------------------------------------------------------------
*- Synopsis...: Open files for release to GL
*------------------------------------------------------------------------------
*- Calls......: D_OPNFL(), G_DSPALT, G_DSPST, G_OPNFL()
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: gc_applid, gc_compid, gc_idrvdbf, ga_segmsk[1]
*-              ln_rlsys, lc_suspen, lc_title, lc_detail, lc_alcash,
*-              lc_alycsh, lc_aldist, lc_alydst, lc_altran, lc_alytrn
*-
*- Parameters.: None
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if error occurred
*-              lc_suspen, lc_title, lc_detail, lc_altran,
*-              lc_alydst, lc_aldist
*-
*- Parameters.: None
*-
*- Files Open.: Opens GLACNT, GLBTCH, GLDUNP, GLHUNP, SYCDFIS,
*-              SYSDATA, and SYUSESS.
*-
*-              For AP:  APDIST, APYDST
*-              For AR:  ARCASH, ARYCSH, ARDIST, ARYDST, ARTRAN, ARYTRN
*-              For IC:  ICDIST, ICYDST, ICTRAN
*------------------------------------------------------------------------------
*- Example:
*-   DO l_opskgl
*------------------------------------------------------------------------------
PROCEDURE l_opskgl

  *-- Display processing message
  DO g_dspst WITH "Opening files for release to GL...", .t., ;
                  gn_msgline, "", "", ""

  *-- Close open files
  go_SQL.m_CloseTableAll()

  *-- Open fiscal calendar detail file
  = g_opnfl(gc_idrvdbf + "sycdfis", "a_sycdfi", .f., .f., "compid1")

  *-- Set filter
  go_SQL.so_CurrentAlias.m_SetFilter("NOT EMPTY(compid + yearprd)")

  *-- Open SYSDATA file
  = g_opnfl(gc_idrvdbf + "sysdata", "a_sysdat", .f., .f., "")

  *-- Set filter
  go_SQL.so_CurrentAlias.m_SetFilter("LEFT(pass2, 1) <> 'D'")

  *-- Find GL system record
  = g_setsys("GL", lc_glcomp, .f.)

  *-- Initialize suspense account
  lc_suspen = SUBSTR(a_sysdat->link, 36, 24)

  *-- Open application files
  DO CASE
    CASE gc_applid = "PR"
      *-- Define heading for report
      lc_title = "Payroll Postings to General Ledger"

      *-- Summary/detail transfer type
      lc_detail = IIF(SUBSTR(a_sysdat->str1, 4, 1) $ "YN", ;
                  SUBSTR(a_sysdat->str1, 4, 1), "N")

      *-- Open History distribution File
      = g_opnfl(gf_prydstf, "a_prydst", .f., .f., "posted")
      lc_alydst = "a_prydst"

      *-- Open Distribution File
      = g_opnfl(gf_prdistf, "a_prdist", .f., .f., "posted")
      lc_aldist = "a_prdist"

    CASE gc_applid = "AP"
      *-- Define heading for report
      lc_title = "Payables Postings to General Ledger"

      *-- Summary/detail transfer type
      lc_detail = IIF(LEFT(a_sysdat->str1, 1) $ "YN", ;
                  LEFT(a_sysdat->str1, 1), "N")

      *-- Open History distribution File
      = g_opnfl(gf_apydstf, "a_apydst", .f., .f., "posted")
      lc_alydst = "a_apydst"

      *-- Open Distribution File
      = g_opnfl(gf_apdistf, "a_apdist", .f., .f., "posted")
      lc_aldist = "a_apdist"

    CASE gc_applid = "AR"
      *-- Define heading for report
      lc_title = "Receivables Postings to General Ledger"

      *-- Summary/detail transfer type
      lc_detail = IIF(SUBSTR(a_sysdat->str1, 2, 1) $ "YN", ;
                  SUBSTR(a_sysdat->str1, 2, 1), "N")

      *-- Open Distribution File
      = g_opnfl(gf_ardistf, "a_ardist", .f., .f., "posted")
      lc_aldist = "a_ardist"

      *-- Open Cash Receipts file
      = g_opnfl(gf_arcashf, "a_arcash", .f., .f., "ctranno")
      lc_alcash = "a_arcash"

      *-- Open Transaction Detail file
      = g_opnfl(gf_artranf, "a_artran", .f., .f., "invno1")
      lc_altran = "a_artran"

      *-- Open History distribution File
      = g_opnfl(gf_arydstf, "a_arydst", .f., .f., "posted")
      lc_alydst = "a_arydst"

      *-- Open History Cash Receipts file
      = g_opnfl(gf_arycshf, "a_arycsh", .f., .f., "ctranno")
      lc_alcash = "a_arycsh"

      *-- Open History Transaction Detail file
      = g_opnfl(gf_arytrnf, "a_arytrn", .f., .f., "invno1")
      lc_alytrn = "a_arytrn"

    CASE gc_applid = "IC"
      *-- Define heading for report
      lc_title = "Inventory Postings to General Ledger"

      *-- Summary/detail transfer type
      lc_detail = IIF(SUBSTR(a_sysdat->str1, 3, 1) $ "YN", ;
                  SUBSTR(a_sysdat->str1, 3, 1), "N")

      *-- Open Distribution File
      = g_opnfl(gf_icdistf, "a_icdist", .f., .f., "posted")
      lc_aldist = "a_icdist"

      *-- Open Transaction Detail file
      = g_opnfl(gf_ictranf, "a_ictran", .f., .f., "ttranno")
      lc_altran = "a_ictran"

      *-- Open History distribution File
      = g_opnfl(gf_icydstf, "a_icydst", .f., .f., "posted")
      lc_alydst = "a_icydst"

      *-- Open History Transaction Detail file
      = g_opnfl(gf_icytrnf, "a_icytrn", .f., .f., "ttranno")
      lc_alytrn = "a_icytrn"

  ENDCASE

  *-- Set file pointer to application system record
  go_SQL.cmpA_Sysdat.m_MoveToRecno(ln_rlsys)

  *-- Open sessions file
  = g_opnfl(gc_idrvdbf + "syusess", "a_syuses", .f., .f., "scompid1")

  *-- Open sessions history file
  = g_opnfl(gc_idrvdbf + "syuyses", "a_syuyse", .f., .f., "scompid1")

  *-- Open accounts file for GL company
  ll_cont = (d_opnfl("GLACNT", lc_glcomp, "", "a_glacnt", .f.) = 1)

  *-- If error on file open
  IF NOT ll_cont
    *-- Display alert
    DO g_dspalt WITH "Error on opening GLACNT" + lc_glcomp + ;
                     ".  Update cancelled.", 3
  ENDIF

  *-- Open batch status file for GL company
  ll_cont = ll_cont AND (d_opnfl("GLBTCH", lc_glcomp, "", ;
            "a_glbtch", .f.) = 1)

  *-- If error on file open
  IF NOT ll_cont
    *-- Display alert
    DO g_dspalt WITH "Error on opening GLBTCH" + lc_glcomp + ;
                     ".  Update cancelled.", 3
  ENDIF

  *-- Open unposted transaction detail file for GL company
  ll_cont = ll_cont AND (d_opnfl("GLDUNP", lc_glcomp, "", ;
            "a_gldunp", .f.) = 1)

  *-- If error on file open
  IF NOT ll_cont
    *-- Display alert
    DO g_dspalt WITH "Error on opening GLDUNP" + lc_glcomp + ;
                     ".  Update cancelled.", 3
  ENDIF

  *-- Open unposted transaction header file for GL company
  ll_cont = ll_cont AND (d_opnfl("GLHUNP", lc_glcomp, "", ;
            "a_glhunp", .f.) = 1)

  *-- If error on file open
  IF NOT ll_cont
    *-- Display alert
    DO g_dspalt WITH "Error on opening GLHUNP" + lc_glcomp + ;
                     ".  Update cancelled.", 3
  ENDIF

  *-- Clear messsage
  DO g_dspst WITH gc_task, .f., gn_msgline, gc_applid, gc_compid, gc_userid

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_opskgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_PRNKGL
*------------------------------------------------------------------------------
*- Description: Print sumary or detail posting register
*------------------------------------------------------------------------------
*- Synopsis...: Print sumary or detail posting register
*------------------------------------------------------------------------------
*- Calls......: G_DSPALT, G_DSPST, G_GETDLG(), G_PRNRP,
*-              APLKGL.FRM, ARLKGL.FRM, ICLKGL.FRM, SYLKGL.FRM
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: gc_applid, gc_idrvtmp, gc_tmpf1, gc_tmpf2, gc_tmpf3,
*-              gc_extdbf, gc_extndx, gc_acctpic, gf_glacntf, gf_apmastf,
*-              gf_arcashf, gf_armastf, gf_arycshf, gf_arymstf,
*-              gf_arytrnf, gf_icytrnf, lc_title, ll_curr, ln_curr,
*-              ll_hist, ln_hist
*-
*- Parameters.: None
*-
*- Files Open.: Assumes destination GLACNT is open.
*-
*-              Opens and closes the following files:
*-
*-              For AP:  APMAST
*-              For AR:  ARMAST, ARYMST
*-              For IC:  None
*-
*-              Assumes the following files are open:
*-
*-              For AP:  APDIST, APYDST
*-              For AR:  ARCASH, ARDIST, ARYCSH, ARYDST
*-              For IC:  ICDIST, ICTRAN, ICYDST, ICYTRN
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: None
*-
*- Parameters.: None
*-
*- Files Open.: Leaves GLACNT open.  Closes other files opened here.
*------------------------------------------------------------------------------
*- Example:
*-   DO l_prnkgl
*------------------------------------------------------------------------------
PROCEDURE l_prnkgl

*\ [1 Line] PTR# 80607 06/08/06 TIRS Declared lc_Tmpmast
*\ [1 Line] PTR# 78455 01/22/05 TIMI Declared and initialized variable lc_tmpf2
  PRIVATE ll_cont, ;
          ln_resp, ;
          lc_head1, ;
          lc_head2, ;
          lc_sessfld, ;
          lc_sesslst, ;
          ln_sessmin, ;
          ln_sessmax, ;
          ln_opnflc, ;
          ln_opnflm, ;
          ln_opnflt, ;
          ln_opnfly, ;
          ll_prnt, ;
          lc_frmfile, ;
          ln_rptcols, ;
          lc_tmpf2, ;
          lc_TmpMast

  lc_tmpf2 = ""

*\ [1 Line] PTR# 73400 01/02/04 TIAU Declared lc_CheckNo as local
  LOCAL lc_CheckNo

  *-- Display dialog for posting register
  ln_resp = g_getdlg("Do you want to print a Posting Register?", 1, 1, ;
            "Summary", "Detail", "No", "")

*\ [1 Line] PTR# 80607 06/08/06 TIRS Initialized lc_Tmpmast
  lc_TmpMast = ""

  *-- If escaped, treat same as no
  IF ln_resp = 0
    ln_resp = 3
  ENDIF

  IF ln_resp = 1 OR ln_resp = 2
    *-- Print register, display processing message
    DO g_dspst WITH "Preparing to print posting register...", .t., ;
                    gn_msgline, "", "", ""

    *-- Setup report titles
    lc_title = gc_applid + IIF(ln_resp = 1, " Summary", " Detail") + ;
               " Posting Register"

    lc_head1 = "Release from " + gc_applid + " company " + gc_compid + ;
               " to GL company " + lc_glcomp

    lc_head2 = ""
  ELSE
    *-- Don't print register, display processing message
    DO g_dspst WITH "Checking ledger posting balance...", .t., ;
                    gn_msgline, "", "", ""
  ENDIF

  *-- Open General Ledger account file
  = g_opnfl(gf_glacntf, "a_glacnt", .f., .f., "glacnt")

  DO CASE
    CASE ln_resp = 1 OR ln_resp = 3
      *-- Summary Report or no report

      *-- Setup session list variables
      lc_sessfld = gc_applid + "SESS"
      ln_sessmin = 0
      ln_sessmax = 0

      *-- Create temporary file
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect("glfyear, glper, glacnt, SUM(amount) AS amount, " + ;
             " MAX(VAL(" + lc_sessfld + ")) AS maxsess, " + ;
             " MIN(VAL(" + lc_sessfld + ")) AS minsess " + ;
             " FROM " + go_SQL.cmp&lc_alydst..sc_tableNameFull + " " + lc_alydst + ;
             " WHERE " + lc_hiscond + ;
             " GROUP BY glfyear, glper, glacnt", ;
             "TABLE", ;
             gc_idrvtmp + gc_tmpf1)
      go_SQL.so_CurrentAlias.m_CloseTable()

      = g_opnfl(gc_idrvtmp + gc_tmpf1 + gc_extdbf, "a_tmpf1", .t., ;
        .f., "", .f., "F")

      go_SQL.m_SQLSelect("glfyear, glper, glacnt, SUM(amount) AS amount, " + ;
             " MAX(VAL(" + lc_sessfld + ")) AS maxsess, " + ;
             " MIN(VAL(" + lc_sessfld + ")) AS minsess " + ;
             " FROM " + go_SQL.cmp&lc_aldist..sc_tableNameFull + " " + lc_aldist + ;
             " WHERE " + lc_curcond + ;
             " GROUP BY glfyear, glper, glacnt", ;
             "TABLE", ;
             gc_idrvtmp + gc_tmpf2)

      go_SQL.cmpA_tmpf1.m_AppendFrom(gc_idrvtmp + gc_tmpf2 + ;
                                          gc_extdbf, "")
      go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")
      go_SQL.m_TableChangeCurrent("a_tmpf1")

      IF ln_resp = 1
        CALCULATE MAX(maxsess), MIN(minsess) TO ln_sessmax, ln_sessmin

        *-- Update report header from session variables
        lc_head2 = "From Session " + LTRIM(STR(ln_sessmin, 6, 0)) + ;
                 "-" + LTRIM(STR(ln_sessmax, 6, 0))
      ENDIF
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

    CASE ln_resp = 2 AND gc_applid = "PR"
      *-- PR Detail Report

      *-- Open history posting file to copy space for employee ID
      ln_opnfly = g_opnfl(gf_prypstf, "a_prypst", .f., .f., "prseqno")

      *-- Open posting file to copy space for employee ID
      ln_opnflm = g_opnfl(gf_prpostf, "a_prpost", .f., .f., "prseqno")

      *-- Select distribution file
      go_SQL.m_TableChangeCurrent(lc_aldist)

      go_SQL.so_CurrentAlias.m_SetRelation("prseqno", "a_prpost", .f.)

      *-- Get current period invoice records
      go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf1, ;
                                      "FIELDS " + ;
                                      "a_prdist.prseqno, " + ;
                                      "a_prdist.glacnt, " + ;
                                      "a_prdist.checkno, " + ;
                                      "a_prdist.ddseqno, " + ;
                                      "a_prdist.glfyear, " + ;
                                      "a_prdist.glper, " + ;
                                      "a_prdist.amount, " + ;
                                      "a_prdist.dsttype, " + ;
                                      "a_prdist.prsess, " + ;
                                      "a_prdist.trandte, " + ;
                                      "a_prpost.prempl FOR " + lc_curcond, "F")

      *-- Clear relation
      go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

      *-- Open temporary file
      = g_opnfl(gc_idrvtmp + gc_tmpf1, "a_tmpf1", .t., .f., "", .f., "F")

      *-- If any unposted records in history file
      IF ll_hist
        *-- Select history distribution file
        go_SQL.m_TableChangeCurrent(lc_alydst)

        go_SQL.so_CurrentAlias.m_SetRelation("prseqno", "a_prpost", .f.)

        *-- Get history invoice records
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, ;
                                        "FIELDS " + ;
                                        "a_prydst.prseqno, " + ;
                                        "a_prydst.glacnt, " + ;
                                        "a_prydst.checkno, " + ;
                                        "a_prydst.ddseqno, " + ;
                                        "a_prydst.glfyear, " + ;
                                        "a_prydst.glper, " + ;
                                        "a_prydst.amount, " + ;
                                        "a_prydst.prsess, " + ;
                                        "a_prydst.trandte, " + ;
                                        "a_prpost.prempl " + ;
                                        "FOR " + lc_hiscond, "F")

        *-- Clear relation
        go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

        *-- Add to temporary file
        go_SQL.m_TableChangeCurrent("a_tmpf1")
        go_SQL.so_CurrentAlias.m_AppendFrom(gc_idrvtmp + gc_tmpf2 + ;
                                            gc_extdbf, "")
        go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")
      ENDIF && ll_hist

      go_SQL.m_TableChangeCurrent("a_tmpf1")

      go_SQL.so_CurrentAlias.m_ScanBegin("", "")

      DO WHILE go_SQL.so_CurrentAlias.m_ScanBulk()

        DO CASE
          CASE EMPTY(a_tmpf1->prseqno)
            *-- do nothing
          CASE go_SQL.cmpA_Prpost.m_Seek(a_tmpf1->prseqno, "")
            go_SQL.so_CurrentAlias.m_ReplaceBulk("prempl WITH " + ;
                                                 "a_prpost->prempl")
          CASE go_SQL.cmpA_Prypst.m_Seek(a_tmpf1->prseqno, "")
            go_SQL.so_CurrentAlias.m_ReplaceBulk("prempl WITH " + ;
                                                 "a_prypst->prempl")
        ENDCASE

      ENDDO

      go_SQL.so_CurrentAlias.m_ScanEnd()

    CASE ln_resp = 2 AND gc_applid = "AP"
      *-- AP Detail Report

      *-- Open invoice file
      ln_opnflm = g_opnfl(gf_apmastf, "a_apmast", .f., .f.)

      go_SQL.cmpA_Apmast.m_SetOrder("vendno1")

      *-- Select distribution file
      go_SQL.m_TableChangeCurrent(lc_aldist)

*\ [Begin] PTR# 73400 01/02/04 TIAU Called m_AlterTable to add field checkno
*\                                  instead of using the column checkno in the
*\                                  m_CopyTo. Also removed the call to m_SetRelation
*\                                  which is not required now.

      *-- Initialize the variable with spaces equivalent to the field variable.
      lc_CheckNo = ALLTRIM(STR(LEN(a_apmast->checkno)))

      *-- Get current period invoice records
      go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf1, ;
                                      "FIELDS " + ;
                                      "a_apdist.invno, " + ;
                                      "a_apdist.vendno, " + ;
                                      "a_apdist.glacnt, " + ;
                                      "a_apdist.glfyear, " + ;
                                      "a_apdist.glper, " + ;
                                      "a_apdist.amount, " + ;
                                      "a_apdist.apsess, " + ;
                                      "a_apdist.trandte, " + ;
                                      "a_apdist.udref, " + ;
                                      "a_apdist.dtstat, " + ;
                                      "a_apdist.dttype, " + ;
                                      "a_apdist.trantype " + ;
                                      "FOR " + lc_curcond, "F")

      *-- Add field checkno
      go_SQL.m_AlterTable(gc_idrvtmp + gc_tmpf1, ;
                          " ADD COLUMN checkno C("  + lc_CheckNo + ")", "F")

      *-- Open temporary file
      = g_opnfl(gc_idrvtmp + gc_tmpf1, "a_tmpf1", .t., .f., "", .f., "F")

      *-- If any unposted records in history file
      IF ll_hist

        go_SQL.cmpA_Apmast.m_SetOrder("vendno1")

        *-- Select history distribution file
        go_SQL.m_TableChangeCurrent(lc_alydst)

        *-- Get history invoice records
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, ;
                                       "FIELDS " + ;
                                       "a_apydst.invno, " + ;
                                       "a_apydst.vendno, " + ;
                                       "a_apydst.glacnt, " + ;
                                       "a_apydst.glfyear, " + ;
                                       "a_apydst.glper, " + ;
                                       "a_apydst.amount, " + ;
                                       "a_apydst.apsess, " + ;
                                       "a_apydst.trandte, " + ;
                                       "a_apydst.udref, " + ;
                                       "a_apydst.dtstat, " + ;
                                       "a_apydst.dttype, " + ;
                                       "a_apydst.trantype " + ;
                                       "FOR " + lc_hiscond, "F")

        *-- Add field checkno
        go_SQL.m_AlterTable(gc_idrvtmp + gc_tmpf2, ;
                            " ADD COLUMN checkno C("  + lc_CheckNo + ")", "F")
*\ [End] PTR# 73400 01/02/04 TIAU

        *-- Add to temporary file
        go_SQL.m_TableChangeCurrent("a_tmpf1")
        go_SQL.so_CurrentAlias.m_AppendFrom(gc_idrvtmp + gc_tmpf2 + ;
                                            gc_extdbf, "")
        go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")
      ENDIF && ll_hist

      *-- Close current period invoices file
      IF ln_opnflm = 2 AND go_SQL.m_IsUsed("a_apmast")
        go_SQL.cmpA_Apmast.m_CloseTable()
      ENDIF

      *-- Update check numbers from reference field
      go_SQL.m_TableChangeCurrent("a_tmpf1")

      go_SQL.so_CurrentAlias.m_ReplaceBulk("checkno WITH " + ;
                               "IIF(dttype = 'R', ALLTRIM(udref), ''), " + ;
                               "udref WITH IIF(dttype = 'R', '', udref)", ;
                               "A", "", .t.)

    CASE ln_resp = 2 AND gc_applid = "AR"
      *-- AR Detail Report

      *-- Open current period invoice header file
      ln_opnflm = g_opnfl(gf_armastf, "a_armast", .f., .f.)

*\ [Begin] PTR# 80607 06/08/06 TIRS Excluded duplicate entries in armast table by fetching
*\                                  unique column values into a temporary table
      lc_TmpMast = go_SQL.m_GetTempTableName(12)

      IF go_SQL.sc_SQLTypeMain = "S"

        *-- Fetched unique records from armast into temporary table
        go_SQL.m_SQLSelect("DISTINCT a_armast.invno, " + ;
                           "a_armast.custno, " + ;
                           "a_armast.refno, " + ;
                           "a_armast.ponum, " + ;
                           "a_armast.artype " + ;
                           "FROM " + go_SQL.cmpA_Armast.sc_TableNameFull + " a_armast ", ;
                           "SQL TABLE", ;
                           lc_TmpMast)

        go_SQL.so_CurrentAlias.m_CloseTable()

        go_SQL.cmpA_Armast.m_CloseTable()

        *-- Open temporary table with armast as alias
        ln_opnflm = g_opnfl(lc_TmpMast, "a_armast", .f., .f.)

        *-- Create temporary index on invoice number column
        go_SQL.so_CurrentAlias.m_CreateIndex("invno", "invno", "", .t., .f.)
      ENDIF
*\ [End] PTR# 80607 06/08/06 TIRS Excluded duplicate entries in armast table by fetching
*\                                unique column values into a temporary table

      *-- Select distribution file
      go_SQL.m_TableChangeCurrent(lc_aldist)

      *-- Get Invoice, Credit Memo, and/or Finance Charge records
      go_SQL.cmpA_Armast.m_SetOrder("invno")
      go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_armast", .f.)

*\ [1 Line] PTR 75119 05/27/04 TIMI Corrected the FOR condition to get exact match record
      go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf1, ;
                                      "FIELDS " + ;
                                      "a_ardist.tranno, " + ;
                                      "a_ardist.glacnt, " + ;
                                      "a_ardist.glfyear, " + ;
                                      "a_ardist.glper, " + ;
                                      "a_ardist.amount, " + ;
                                      "a_ardist.arsess, " + ;
                                      "a_ardist.trandte, " + ;
                                      "a_ardist.dsttype, " + ;
                                      "a_armast.invno, " + ;
                                      "a_armast.custno, " + ;
                                      "a_armast.refno, " + ;
                                      "a_armast.ponum, " + ;
                                      "a_armast.artype " + ;
                                      "FOR LEFT(a_ardist.dsttype,1) <> 'R' AND " + ;
                                      lc_curcond, "F")

*\ [Begin] PTR# 80607 06/08/06 TIRS Closed the temporary armast table and reopened
*\                                  the live table
      IF go_SQL.sc_SQLTypeMain = "S"

        *-- Clear the relation with the temporary table
        go_SQL.so_CurrentAlias.m_SetRelation("")

        *-- Close temporary armast table
        go_SQL.cmpA_Armast.m_CloseTable()

        go_SQL.m_DropTable(lc_TmpMast)

        *-- Re-open master table
        ln_opnflm = g_opnfl(gf_armastf, "a_armast", .f., .f.)

        go_SQL.cmpA_Armast.m_SetOrder("invno")

        go_SQL.m_TableChangeCurrent(lc_aldist)
      ENDIF
*\ [End] PTR# 80607 06/08/06 TIRS Closed the temporary armast table and reopened
*\                                the live table

      *-- Get Cash Receipt records
      go_SQL.cmpA_Arcash.m_SetOrder("ctranno")
      
*\ [Begin] PTR# 78455 01/22/05 TIMI Workaround done to avoid duplicate records in SQL while
*\                                  copying data from 2 tables by setting relation and the
*\                                  tables having many to many relationships 

*!*	      go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arcash", .f.)

*!*	*\ [1 Line] PTR 75119 05/27/04 TIMI Corrected the FOR condition to get exact match record
*!*	      go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, ;
*!*	                                      "FIELDS " + ;
*!*	                                      "a_ardist.tranno, " + ;
*!*	                                      "a_ardist.glacnt, " + ;
*!*	                                      "a_ardist.glfyear, " + ;
*!*	                                      "a_ardist.glper, " + ;
*!*	                                      "a_ardist.amount, " + ;
*!*	                                      "a_ardist.arsess, " + ;
*!*	                                      "a_ardist.trandte, " + ;
*!*	                                      "a_ardist.dsttype, " + ;
*!*	                                      "a_arcash.invno, " + ;
*!*	                                      "a_arcash.custno, " + ;
*!*	                                      "a_arcash.refno, " + ;
*!*	                                      "a_arcash.ponum, " + ;
*!*	                                      "a_arcash.artype " + ;
*!*	                                      "FOR LEFT(a_ardist.dsttype,1) = 'R' AND  " + ;
*!*	                                      lc_curcond, "F")
      go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

      *-- Get temporary file name
      lc_tmpf2 = go_SQL.m_GetTempTableName(2)             

      *-- Workaround done for copying columns from two tables having many to many relationships
      *-- (to avoid duplicates when connected to SQL) by copying the required columns from first
      *-- table and with dummy columns representing the second table. Dummy columns representing
      *-- the second table will be updated subsequently. This has been done to have a common
      *-- behavior of handling relation when connected to either VFP or SQL

      *-- Create temporary file structure
      go_SQL.m_SQLSelect("tranno, " + ;
                         "glacnt, " + ;
                         "glfyear, " + ;
                         "glper, " + ;
                         "amount, " + ;
                         "arsess, " + ;
                         "trandte, " + ;
                         "dsttype, " + ;
                         "SPACE(" + TRIM(STR(LEN(a_arcash.invno))) + ") AS invno, " + ;
                         "SPACE(" + TRIM(STR(LEN(a_arcash.custno))) + ") AS custno, " + ;
                         "SPACE(" + TRIM(STR(LEN(a_arcash.refno))) + ") AS refno, " + ;
                         "SPACE(" + TRIM(STR(LEN(a_arcash.ponum))) + ") AS ponum, " + ;
                         "SPACE(" + TRIM(STR(LEN(a_arcash.artype))) + ") AS artype " + ;
                         "FROM " + go_SQL.so_CurrentAlias.sc_TableNameFull + " a_ardist " + ;
                         "WHERE LEFT(a_ardist.dsttype,1) = 'R' AND  " + ;
                         lc_curcond, ;
                         "SQL TABLE", ;
                         lc_tmpf2)

      *-- Close and Reopen temporary report file
      go_SQL.so_CurrentAlias.m_CloseTable()

      = g_opnfl(lc_tmpf2, "a_tmpf2", .f., .f.)
      go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arcash", .f.)

      *-- Update arcash related fields
      go_SQL.so_CurrentAlias.m_ReplaceBulk("invno WITH a_arcash->invno, " + ;
                                           "custno WITH a_arcash->custno, " + ;
                                           "refno WITH a_arcash->refno, " + ;
                                           "ponum WITH a_arcash->ponum, " + ;
                                           "artype WITH a_arcash->artype" , ;
                                           "F", ;
                                           "NOT go_SQL.cmpA_Arcash.m_IsEof()", ;
                                           .t.)

      *-- Clear relation
      go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

      *-- Close current period invoice header file
      IF ln_opnflm = 2 AND go_SQL.m_IsUsed("a_armast")
        go_SQL.cmpA_Armast.m_CloseTable()
      ENDIF

       *-- Open temporary file
      = g_opnfl(gc_idrvtmp + gc_tmpf1, "a_tmpf1", .t., .f., "", .f., "F")

      *-- Append cash postings
      go_SQL.so_CurrentAlias.m_AppendFrom(lc_tmpf2, "")

      go_SQL.cmpA_Tmpf2.m_CloseTable()
      go_SQL.m_DropTable(lc_tmpf2)
*\   [End] PTR# 78455 01/22/05 TIMI Workaround done to avoid duplicate records in SQL while
*\                                  copying data from 2 tables by setting relation and the
*\                                  tables having many to many relationships 

      *-- If any unposted records in history file
      IF ll_hist
        *-- Open history invoice header file
        ln_opnflm = g_opnfl(gf_arymstf, "a_arymst", .f., .f.)

        *-- Reselect history distribution file
        go_SQL.m_TableChangeCurrent(lc_alydst)

        *-- Get Invoice, Credit Memo, and/or Finance Charge records
        go_SQL.cmpA_Arymst.m_SetOrder("invno")
        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arymst", .f.)

*\ [1 Line] PTR 78455 01/27/05 TIMI Used the correct alias in FOR condition
*\ [1 Line] PTR 75119 05/27/04 TIMI Corrected the FOR condition to get exact match record
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf3, ;
                                        "FIELDS " + ;
                                        "a_arydst.tranno, " + ;
                                        "a_arydst.glacnt, " + ;
                                        "a_arydst.glfyear, " + ;
                                        "a_arydst.glper, " + ;
                                        "a_arydst.amount, " + ;
                                        "a_arydst.arsess, " + ;
                                        "a_arydst.trandte, " + ;
                                        "a_arydst.dsttype, " + ;
                                        "a_arymst.invno, " + ;
                                        "a_arymst.custno, " + ;
                                        "a_arymst.refno, " + ;
                                        "a_arymst.ponum, " + ;
                                        "a_arymst.artype " + ;
                                        "FOR LEFT(a_arydst.dsttype,1) <> 'R' AND " + ;
                                        lc_hiscond, "F")

        *-- Get history cash receipt records
        go_SQL.cmpA_Arycsh.m_SetOrder("ctranno")

*\ [Begin] PTR# 78455 01/22/04 TIMI Workaround done to avoid duplicate records in SQL

*!*	        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arycsh", .f.)

*!*	*\ [1 Line] PTR 75119 05/27/04 TIMI Corrected the FOR condition to get exact match record
*!*	        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, ;
*!*	                                        "FIELDS " + ;
*!*	                                        "a_arydst.tranno, " + ;
*!*	                                        "a_arydst.glacnt, " + ;
*!*	                                        "a_arydst.glfyear, " + ;
*!*	                                        "a_arydst.glper, " + ;
*!*	                                        "a_arydst.amount, " + ;
*!*	                                        "a_arydst.arsess, " + ;
*!*	                                        "a_arydst.trandte, " + ;
*!*	                                        "a_arydst.dsttype, " + ;
*!*	                                        "a_arycsh.invno, " + ;
*!*	                                        "a_arycsh.custno, " + ;
*!*	                                        "a_arycsh.refno, " + ;
*!*	                                        "a_arycsh.ponum, " + ;
*!*	                                        "a_arycsh.artype " + ;
*!*	                                        "FOR LEFT(a_ardist.dsttype,1) = 'R' AND " + ;
*!*	                                        lc_hiscond, "F")
        go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

        *-- Get temporary file name
        lc_tmpf2 = go_SQL.m_GetTempTableName(2)

        *-- Workaround done for copying columns from two tables having many to many relationships
        *-- (to avoid duplicates when connected to SQL) by copying the required columns from first
        *-- table and with dummy columns representing the second table. Dummy columns representing
        *-- the second table will be updated subsequently. This has been done to have a common
        *-- behavior of handling relation when connected either VFP or SQL

        *-- Create temporary file structure
        go_SQL.m_SQLSelect("tranno, " + ;
                           "glacnt, " + ;
                           "glfyear, " + ;
                           "glper, " + ;
                           "amount, " + ;
                           "arsess, " + ;
                           "trandte, " + ;
                           "dsttype, " + ;
                           "SPACE(" + TRIM(STR(LEN(a_arycsh.invno))) + ") AS invno, " + ;
                           "SPACE(" + TRIM(STR(LEN(a_arycsh.custno))) + ") AS custno, " + ;
                           "SPACE(" + TRIM(STR(LEN(a_arycsh.refno))) + ") AS refno, " + ;
                           "SPACE(" + TRIM(STR(LEN(a_arycsh.ponum))) + ") AS ponum, " + ;
                           "SPACE(" + TRIM(STR(LEN(a_arycsh.artype))) + ") AS artype " + ;
                           "FROM " + go_SQL.so_CurrentAlias.sc_TableNameFull + " a_arydst " + ;
                           "WHERE LEFT(a_arydst.dsttype,1) = 'R' AND  " + ;
                           lc_hiscond, ;
                           "SQL TABLE", ;
                           lc_tmpf2)

        *-- Close and Reopen temporary report file
        go_SQL.so_CurrentAlias.m_CloseTable()

        = g_opnfl(lc_tmpf2, "a_tmpf2", .f., .f.)

        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arycsh", .f.)

        *-- Update arcash related fields
        go_SQL.so_CurrentAlias.m_ReplaceBulk("invno WITH a_arycsh->invno, " + ;
                                             "custno WITH a_arycsh->custno, " + ;
                                             "refno WITH a_arycsh->refno, " + ;
                                             "ponum WITH a_arycsh->ponum, " + ;
                                             "artype WITH a_arycsh->artype" , ;
                                             "F", ;
                                             "NOT go_SQL.cmpA_Arycsh.m_IsEof()", ;
                                             .t.)

        *-- Clear relation
        go_SQL.so_CurrentAlias.m_SetRelation("", "", .f.)

        *-- Close history invoice header file
        IF ln_opnflm = 2 AND go_SQL.m_IsUsed("a_arymst")
          go_SQL.cmpA_Arymst.m_CloseTable()
        ENDIF

        *-- Add to temporary file
        go_SQL.m_TableChangeCurrent("a_tmpf1")
        go_SQL.so_CurrentAlias.m_AppendFrom(lc_tmpf2, "")
        go_SQL.so_CurrentAlias.m_AppendFrom(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "")

        *-- Close the opened temporary table
        go_SQL.cmpA_Tmpf2.m_CloseTable()

        go_SQL.m_DropTable(lc_tmpf2)
        go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "", "F")
*\ [End] PTR# 78455 01/22/05 TIMI Workaround done to avoid duplicate records in SQL

      ENDIF && ll_hist

    CASE ln_resp = 2 AND gc_applid = "IC"
      *-- IC Detail Report

      *-- Select distribution file
      go_SQL.m_TableChangeCurrent(lc_aldist)

      *-- Get current period inventory transaction records
      go_SQL.cmpA_Ictran.m_SetOrder("ttranno")

      *-- Initialize the variables with spaces equivalent to the field variables.
      lc_Item1    = SPACE(LEN(a_ictran.item))
      lc_Trantyp1 = SPACE(LEN(a_ictran.trantyp))
      lc_Udref1   = SPACE(LEN(a_ictran.udref))
      lc_applid1  = SPACE(LEN(a_ictran.applid))
      lc_docno1   = SPACE(LEN(a_ictran.docno))

      *-- Workaround done to avoid duplicate entries in Posting Register when
      *-- ICTRAN contains individual records for each costing tier.
      go_SQL.m_SqlSelect("a_icdist.tranno, " + ;
                         "a_icdist.glacnt, " + ;
                         "a_icdist.glfyear, " + ;
                         "a_icdist.glper, " + ;
                         "a_icdist.amount, " + ;
                         "a_icdist.icsess, " + ;
                         "a_icdist.trandte, " + ;
                         "??lc_item1 As Item, " + ;
                         "??lc_trantyp1 As Trantyp, " + ;
                         "??lc_udref1 As Udref, " + ;
                         "??lc_applid1 As Applid, " + ;
                         "??lc_docno1 As Docno, " + ;
                         "a_icdist.posted FROM " + go_Sql.cmpA_icdist.sc_tablenamefull + ;
                         " a_icdist WHERE " + lc_curcond, ;
                         "TABLE", (gc_idrvtmp + gc_tmpf1))
      go_SQl.so_Currentalias.m_CloseTable()

      *-- Open temporary file
      = g_opnfl(gc_idrvtmp + gc_tmpf1, "a_tmpf1", .t., .f., "", .f., "F")

      go_SQL.so_CurrentAlias.m_ScanBegin("", "")

      DO WHILE go_SQL.so_CurrentAlias.m_ScanBulk()
        *--Replace the fields with the values in ICTRAN.

        go_Sql.cmpA_ictran.m_Seek(tranno,"")
        go_Sql.so_CurrentAlias.m_ReplaceBulk("item with a_ictran.item, " + ;
                                             "trantyp with a_ictran.trantyp, " + ;
                                             "udref with a_ictran.udref, " + ;
                                             "applid with a_ictran.applid, " + ;
                                             "docno with a_ictran.docno")

      ENDDO

      go_SQl.m_TablechangeCurrent("a_tmpf1")

      go_Sql.so_CurrentAlias.m_ScanEnd()

      *-- If any unposted records in history file
      IF ll_hist
        *-- Reselect history distribution file
        go_SQL.m_TableChangeCurrent(lc_alydst)

        *-- Get history inventory transaction records
        go_SQL.cmpA_Icytrn.m_SetOrder("ttranno")

        *-- Initialize the variables with spaces equivalent to the field variables.
        lc_Item2    = SPACE(LEN(a_icytrn.item))
        lc_Trantyp2 = SPACE(LEN(a_icytrn.trantyp))
        lc_Udref2   = SPACE(LEN(a_icytrn.udref))
        lc_applid2  = SPACE(LEN(a_icytrn.applid))
        lc_docno2   = SPACE(LEN(a_icytrn.docno))

        *-- Workaround done to avoid duplicate entries in Posting Register when
        *-- ICYTRN contains individual records for each costing tier.
        go_SQL.m_SqlSelect("a_icydst.tranno, " + ;
                           "a_icydst.glacnt, " + ;
                           "a_icydst.glfyear, " + ;
                           "a_icydst.glper, " + ;
                           "a_icydst.amount, " + ;
                           "a_icydst.icsess, " + ;
                           "a_icydst.trandte, " + ;
                           "??lc_item2 As 'Item', " + ;
                           "??lc_trantyp2 As 'Trantyp', " + ;
                           "??lc_udref2 As 'Udref', " + ;
                           "??lc_applid2 As 'Applid', " + ;
                           "??lc_docno2 As 'Docno' " + ;
                           " FROM " + go_Sql.cmpA_icydst.sc_tablenamefull + ;
                           " a_icydst WHERE " + lc_hiscond, ;
                           "TABLE", (gc_idrvtmp + gc_tmpf2))
        go_SQl.so_Currentalias.m_CloseTable()

        *-- Open temporary file
        = g_opnfl(gc_idrvtmp + gc_tmpf2, "a_tmpf2", .t., .f., "", .f., "F")

        go_SQL.so_CurrentAlias.m_ScanBegin("", "")

        DO WHILE go_SQL.so_CurrentAlias.m_ScanBulk()
          *--Replace the fields with the values in ICYTRN.

          go_Sql.cmpA_icytrn.m_Seek(tranno,"")
          go_Sql.so_CurrentAlias.m_ReplaceBulk("item with a_icytrn.item, " + ;
                                               "trantyp with a_icytrn.trantyp, " + ;
                                               "udref with a_icytrn.udref, " + ;
                                               "applid with a_icytrn.applid, " + ;
                                               "docno with a_icytrn.docno")

        ENDDO

        go_SQl.m_TablechangeCurrent("a_tmpf2")

        go_Sql.so_CurrentAlias.m_ScanEnd()

        *-- Add unposted records to temporary file for report
        go_SQL.m_TableChangeCurrent("a_tmpf1")
        go_SQL.so_CurrentAlias.m_AppendFrom(gc_idrvtmp + gc_tmpf2 + ;
                                            gc_extdbf, "")
        go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")
      ENDIF & ll_hist

  ENDCASE

  *-- Select report file
  go_SQL.m_TableChangeCurrent("a_tmpf1")

  IF ln_resp = 1 OR ln_resp = 2
    *-- Build index on account number and set relation to accounts file
    go_SQL.so_CurrentAlias.m_CreateIndex(lc_prttag, ;
                                         "glfyear + glper + glacnt", ;
                                         "", .t., .f.)

    *-- Set print flag
    ll_prnt = .t.

    *-- Setup report form file names and control variables
    IF ln_resp = 1
      *-- Summary
      lc_frmfile = gc_idrvprg + "sylkgl"
      ln_rptcols = 96

      *# DOCCODE REPORT FORM sylkgl
    ELSE
      *-- Detail
      lc_frmfile = gc_adrvprg + gc_applid + "lkgl"

      *-- AP and PR reports requires only 96 columns
      IF UPPER(gc_applid) $ "AP~PR"
        ln_rptcols = 96
      ELSE
        ln_rptcols = 132
      ENDIF

      *# DOCCODE REPORT FORM prlkgl
      *# DOCCODE REPORT FORM aplkgl
      *# DOCCODE REPORT FORM arlkgl
      *# DOCCODE REPORT FORM iclkgl
    ENDIF

    DO g_prnrp WITH .t.

    *-- Clear relation and filter
    go_SQL.so_CurrentAlias.m_SetFilter("")
  ENDIF && ln_resp = 1 OR ln_resp = 2

  *-- Calculate balance
  go_SQL.m_TableChangeCurrent("a_tmpf1")
  go_SQL.so_CurrentAlias.m_Calculate("SUM(amount)", "ln_bal")

  *-- Close and delete temporary files
  IF go_SQL.m_IsUsed("a_tmpf1")
    go_SQL.cmpA_Tmpf1.m_CloseTable()
  ENDIF

  go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf1 + gc_extdbf, "", "F")

  IF go_SQL.m_IsUsed("a_tmpf2")
    go_SQL.cmpA_Tmpf2.m_CloseTable()
  ENDIF

  go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "", "F")

  IF go_SQL.m_IsUsed("a_tmpf3")
    go_SQL.cmpA_Tmpf3.m_CloseTable()
  ENDIF

  go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "", "F")

  *-- Clear messsage
  DO g_dspst WITH gc_task, .f., gn_msgline, gc_applid, gc_compid, gc_userid

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_prnkgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_VALKGL
*------------------------------------------------------------------------------
*- Description: Validate GL account numbers and posting periods
*------------------------------------------------------------------------------
*- Synopsis...: Validate GL account numbers and posting periods from
*-              source transaction file.
*------------------------------------------------------------------------------
*- Calls......: G_DSPALT, G_DSPST, G_GETDLG()
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: lc_glcomp, lc_suspen
*-
*- Parameters.: lc_alias,  source file alias
*-              ln_maxrec, maximum record number to be processed in
*-                         source file
*-              lc_cond,   validatation for current/history files
*-
*- Files Open.: Assumes source xxDIST/xxYDST, destination GLACNT, and
*-              SYCDFIS are open.
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if processing cancelled
*-
*- Parameters.: None
*-
*- Files Open.: Leaves all files open.
*------------------------------------------------------------------------------
*- Example:
*-   DO l_valkgl WITH lc_aldist, ln_curr, lc_cond
*------------------------------------------------------------------------------
PROCEDURE l_valkgl

PARAMETERS lc_alias, ;
           ln_maxrec, ;
           lc_cond

  PRIVATE lc_glacnt, ;
          ln_resp

  *-- Set index orders in chart of accounts and fiscal calendar files
  go_SQL.cmpA_Glacnt.m_SetOrder("glacnt")
  go_SQL.cmpA_Sycdfi.m_SetOrder("compid1")

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
  go_SQL.m_SqlSelect("DISTINCT glacnt, glper, glfyear FROM " + go_Sql.cmp&lc_alias..sc_tablenamefull + " " + lc_alias + ;
                     " WHERE " + lc_cond, ;
                     "TABLE", (gc_idrvtmp + gc_tmpf6))

  go_SQL.so_CurrentAlias.m_CloseTable()

  = g_opnfl(gc_idrvtmp + gc_tmpf6 + gc_extdbf, "a_tmpf6", .t., .f., "", .f., "F")

  *-- Validate GL account numbers in source file
  SCAN WHILE NOT EOF()
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

    *-- Save account number and posting year/period
    lc_glacnt  = glacnt
    lc_glfyear = glfyear
    lc_glper   = glper

    *-- Display processing message
    DO g_dspst WITH "Checking posting to account " + ALLTRIM(lc_glacnt) + ;
                    ", period " + lc_glfyear + "/" + lc_glper + "...", ;
                    .t., gn_msgline, "", "", ""

    *-- Search for account number in GLACNT
*\ [1 Line] PTR# 74180 06/22/04 TIAI Fix for performance optimization
    go_SQL.cmpA_glacnt.m_Seek(lc_glacnt, "")

    *-- Check for invalid, deleted, or inactive account number
    DO CASE
      CASE NOT go_SQL.cmpA_Glacnt.m_IsFound()
        *-- If invalid, display dialog
        ln_resp = g_getdlg("Account " + ALLTRIM(lc_glacnt) + ;
                  " not found in Chart of Accounts." + gc_oseol + ;
                  "Transfer to Suspense Account (" + ALLTRIM(lc_suspen) + ;
                  ") or cancel" + gc_oseol + "release to GL?", 1, 1, ;
                  "Suspense", "Cancel", "", "")

      CASE DELETED("a_glacnt")
        *-- If deleted, display dialog
        ln_resp = g_getdlg("Account " + ALLTRIM(lc_glacnt) + ;
                  " is deleted in Chart of Accounts." + gc_oseol + ;
                  "Transfer to Suspense Account (" + ALLTRIM(lc_suspen) + ;
                  ") or cancel" + gc_oseol + "release to GL?", 1, 1, ;
                  "Suspense", "Cancel", "", "")

      CASE a_glacnt->glstat = "I"
        *-- If inactive, display dialog
        ln_resp = g_getdlg("Account " + ALLTRIM(lc_glacnt) + ;
                  " is marked as Inactive in Chart of" + gc_oseol + ;
                  " Accounts.  Transfer to Suspense Account (" + ;
                  ALLTRIM(lc_suspen) + ")" + gc_oseol + ;
                  "or cancel release to GL?", 1, 1, ;
                  "Suspense", "Cancel", "", "")

      OTHERWISE
        *-- Passed all account number validations
        ln_resp = 3

    ENDCASE

    *-- If passed check or not cancelled on account number check
    IF ln_resp = 1 OR ln_resp = 3
      *-- Search for posting period in SYCDFIS
*\ [1 Line] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.cmpA_Sycdfi.m_Seek(lc_glcomp + lc_glfyear + lc_glper, "")

      *-- Check for invalid, deleted, or locked posting period
      DO CASE
        CASE NOT go_SQL.cmpA_Sycdfi.m_IsFound()
          *-- If invalid, set flag to cancel and display alert
          ln_resp = 2
          DO g_dspalt WITH "Posting period " + lc_glper + "/" + ;
                           lc_glfyear +  " not found in fiscal calendar." + ;
                           gc_oseol + "Unable to continue with release " + ;
                           "to GL.", 3

        CASE DELETED("a_sycdfi")
          *-- If deleted, set flag to cancel and display alert
          ln_resp = 2
          DO g_dspalt WITH "Posting period " + lc_glper + "/" + ;
                           lc_glfyear +  " is deleted in fiscal calendar." + ;
                           gc_oseol + "Unable to continue with release " + ;
                           "to GL.", 3

        CASE a_sycdfi->permlck = gx_true
          *-- If period marked as permanantly locked,
          *-- set flag to cancel and display alert
          ln_resp = 2
          DO g_dspalt WITH "Posting period " + lc_glper + "/" + ;
                           lc_glfyear + " is permanantly locked in " + ;
                           "fiscal calendar." + gc_oseol + "You must " + ;
                           "unlock the period before postings can be " + ;
                           "released." + gc_oseol + "Unable to continue " + ;
                           "with release to GL.", 3

        CASE a_sycdfi->plocked = gx_true
          *-- If period marked as locked,
          *-- set flag to cancel and display alert
          ln_resp = 2
          DO g_dspalt WITH "Posting period " + lc_glper + "/" + ;
                           lc_glfyear + " is locked in fiscal " + ;
                           "calendar.  You" + gc_oseol + "must unlock " + ;
                           "the period before postings can be released." + ;
                           gc_oseol + "Unable to continue with release " + ;
                           "to GL.", 3

        OTHERWISE
          *-- Passed all posting period validations
          ln_resp = 3

      ENDCASE

    ENDIF && ln_resp = 1 OR ln_resp = 3

    *-- If Escape or Cancel
    IF ln_resp = 0 OR ln_resp = 2
      *-- Escape or Cancel, set flag and exit
      ll_cont = .f.
      EXIT
    ENDIF

    *-- Move to next record in source file
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
    SELECT a_tmpf6
  ENDSCAN

  IF go_SQL.m_IsTableFound(gc_idrvtmp + gc_tmpf6 + gc_extdbf, "F")
    go_SQL.m_DropTable(gc_idrvtmp + gc_tmpf6 + gc_extdbf, "", "F")
  ENDIF
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

  *-- Clear messsage
  DO g_dspst WITH gc_task, .f., gn_msgline, gc_applid, gc_compid, gc_userid

RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_valkgl
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_GETDES
*------------------------------------------------------------------------------
*- Description: Gets the Description of GL Account Number
*------------------------------------------------------------------------------
*- Synopsis...: This procedure is called from the Reports to get the
*-              description of account numbers from GLACNT.DBF and display them
*-
*------------------------------------------------------------------------------
*- Calls......: None
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: None
*-
*- Parameters.: lc_Glacnt, account to search for description
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: lc_Gldesc, account description
*-
*- Parameters.: None
*-
*- Files Open.: GLACNT, A_TMPF1
*-
*------------------------------------------------------------------------------
*- Example:
*-   l_getdes(a_tmpf1.glacnt)
*------------------------------------------------------------------------------
PROCEDURE l_getdes

PARAMETERS lc_Glacnt

  PRIVATE lc_Gldesc

  lc_Gldesc = ""

  *-- Find account record
  IF go_SQL.cmpA_Glacnt.m_Seek(lc_Glacnt, "glacnt")
    lc_Gldesc = a_Glacnt->gldesc
  ENDIF

RETURN (lc_Gldesc)
*------------------------------------------------------------------------------
*- End Procedure...: l_getdes
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*- Procedure..: L_INDKGL
*------------------------------------------------------------------------------
*- Description: Do prior settings before Loading temporary GL files from
*-              transaction file. Create necessary indexes and filters before
*-              releasing to GL.
*------------------------------------------------------------------------------
*- Synopsis...: Load temporary GL files from transaction file
*------------------------------------------------------------------------------
*- Calls......: G_DSPALT, G_DSPST, G_GETGLB(), G_GETGLT()
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: lc_glcomp, lc_detail, lc_suspen, lc_alcash, lc_alycsh,
*-              lc_altran, lc_alytrn
*-
*- Parameters.: lc_alias,  source file alias
*-              ln_maxrec, maximum record number to be processed in
*-                         source file
*-              lc_cond,   validatation for current/history files
*-              lc_tag,   index file name for current/history files
*-
*- Files Open.: Assumes source xxDIST/xxYDST and destination GLBTCH,
*-              GLDUNP, and GLHUNP files are open and all file locked.
*-
*-              Assumes the following files are open:
*-
*-              For AP:  APDIST, APYDST
*-              For AR:  ARCASH, ARDIST, ARTRAN, ARYCSH, ARYDST, ARYTRN
*-              For IC:  ICDIST, ICTRAN, ICYDST, ICYTRN
*------------------------------------------------------------------------------
*- Returns:
*- Variables..: ll_cont set to .f. if error occurred
*-
*- Parameters.: None
*-
*- Files Open.: Leaves all files open.
*------------------------------------------------------------------------------
*- Example:
*-   DO l_indkgl WITH lc_aldist, ln_curr, lc_curcond, lc_currtag
*------------------------------------------------------------------------------
PROCEDURE l_indkgl

PARAMETERS lc_alias, ;
           ln_maxrec, ;
           lc_cond, ;
           lc_tag

  PRIVATE lc_docexp, ;
          lc_sumexp, ;
          lc_ndxexp, ;
          lc_yearprd, ;
          lc_batchno, ;
          lc_sess, ;
          la_sess, ;
          ln_sesscnt, ;
          ln_sess, ;
          ld_gldate, ;
          lc_tranno, ;
          ln_tdrtot, ;
          ln_tcrtot, ;
          ln_bdrtot, ;
          ln_bcrtot, ;
          lc_gltdes, ;
          ln_amount, ;
          lc_glacnt, ;
          lc_dockey, ;
          lc_subdetl

  go_SQL.m_TableChangeCurrent(lc_alias)
  go_SQL.so_CurrentAlias.m_Setfilter(lc_cond)

  *-- Set index order in chart of accounts file
  go_SQL.cmpA_Glacnt.m_SetOrder("glacnt")

  *-- Initialize array to hold session numbers
  DECLARE la_sess[1]
  la_sess[1] = ""
  ln_sesscnt = 0

  *-- Setup summarization and index key expressions
  IF lc_detail = "N"
    *-- Summary
    lc_sumexp = [.t.]
*/ [3 lines] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
    lc_ndxexp = "glfyear + glper " + ;
                  IIF(gc_applid = "AP" OR gc_applid = "AR", "+ trantype ", "") + ;
                  "+ glacnt"
    lc_docexp = ""
    lc_dockey = ""
  ENDIF

  *-- Setup summarization and index key expressions
  DO CASE
    CASE gc_applid = "AP"

      IF lc_detail = "Y"
        *-- Accounts Payable, Detail
        lc_sumexp = lc_alias + [->dttype = "P"]
*/ [1 line] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
        lc_ndxexp = [glfyear + glper + trantype + apsess + IIF(] + lc_sumexp + ;
                    [, "C", "P") + ALLTRIM(glacnt)]

        *-- Set expression for document number lookup
        lc_docexp = [ALLTRIM(] + lc_alias + [->vendno) + ALLTRIM(] + ;
                    lc_alias + [->invno)]
      ENDIF

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno " + ;
                         " FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "TABLE", ;
                         IIF(lc_alias = "a_apdist", gc_idrvtmp + gc_tmpf2, gc_idrvtmp + gc_tmpf3))
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      IF lc_alias = "a_apdist"
        *-- Open the main table in a different alias
        = g_opnfl(gf_apdistf, "a_apdis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_apdist", .t., ;
                  .f., "", .f., "F")
      ELSE
        *-- Open the main table in a different alias
        = g_opnfl(gf_apydstf, "a_apyds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_apydst", .t., ;
                  .f., "", .f., "F")
      ENDIF

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      IF lc_detail = "Y"
        go_SQL.so_CurrentAlias.m_Replacebulk("glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt), " + ;
                                             "subdetl WITH IIF(NOT dttype = 'P', vendno + invno, ''), " + ;
                                             "gltdes WITH 'V# ' + ALLTRIM(vendno) + ' IV# ' + ALLTRIM(invno) + ' ' + ALLTRIM(udref)", ; 
                                             "A", "", .t.)
      ELSE
        go_SQL.so_CurrentAlias.m_Replacebulk("glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", "", .t.)
      ENDIF
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

    CASE gc_applid = "AR" AND lc_detail = "N"

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno " + ;
                         " FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "TABLE", ;
                         IIF(lc_alias = "a_ardist", gc_idrvtmp + gc_tmpf2, gc_idrvtmp + gc_tmpf3))
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      IF lc_alias = "a_ardist"
        *-- Open the main table in a different alias
        = g_opnfl(gf_ardistf, "a_ardis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_ardist", .t., ;
                  .f., "", .f., "F")
      ELSE
        *-- Open the main table in a different alias
        = g_opnfl(gf_arydstf, "a_aryds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_arydst", .t., ;
                  .f., "", .f., "F")
      ENDIF

*\ [2 Lines] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.so_CurrentAlias.m_Replacebulk("glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                           "A", "", .t.)

    CASE gc_applid = "AR" AND lc_detail = "Y"
      *-- Accounts Receivable, Detail
      lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
*/ [1 line] PTR# 41177 SOCO 04/28/04 Add transaction type for Reversing Entries.
      lc_ndxexp = [glfyear + glper + trantype + arsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      lc_docexp = [custno + invno]

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)

      *-- Since the index based on the other table's field is not supported by
      *-- SQL framework, a copy of ARDIST/ARYDST is taken in to a temporary
      *-- table where the values from ARCASH/ARTRAN is stored in a new column
      *-- of the temporary table and indexed. The temporary table is then
      *-- opened in the alias name of original table.
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, SPACE(" + STR(FSIZE("CUSTNO", "a_arcash")) + ") AS custno, " + ;
                         "SPACE(" + STR(FSIZE("INVNO", "a_arcash")) + ") AS invno, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "SQL TABLE", ;
                         IIF(lc_alias = "a_ardist", lf_Stemp4, lf_Stemp5))

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      *-- Open temporary file
      IF lc_alias = "a_ardist"
        = g_opnfl(lf_Stemp4, ;
                  "a_tmpf4", ;
                  .t.)
      ELSE
        = g_opnfl(lf_Stemp5, ;
                  "a_tmpf5", ;
                  .t.)
      ENDIF

      go_SQL.so_currentalias.m_createIndex("tranno", "tranno", "", .f., .f.)
      go_SQL.so_currentalias.m_createIndex("tranno1", "tranno + STR(tranlineno,4)", "tranno, tranlineno", .f., .f.)
      go_SQL.so_currentalias.m_setorder()
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      IF lc_alias = "a_ardist"
        *-- Current file
        go_SQL.cmpA_Arcash.m_SetOrder("ctranno")
        go_SQL.cmpA_Artran.m_SetOrder("invno1")
        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arcash", .f.)
        go_SQL.so_CurrentAlias.m_SetRelation("tranno + STR(tranlineno,4)", ;
                                             "a_artran", .t.)
      ELSE
        *-- History file
        go_SQL.cmpA_Arycsh.m_SetOrder("ctranno")
        go_SQL.cmpA_Arytrn.m_SetOrder("invno1")
        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_arycsh", .f.)
        go_SQL.so_CurrentAlias.m_SetRelation("tranno + STR(tranlineno,4)", ;
                                             "a_arytrn", .t.)
      ENDIF

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      IF lc_alias = "a_ardist"
        go_SQL.so_CurrentAlias.m_Replacebulk("custno WITH IIF(LEFT(dsttype, 1) = 'R', a_arcash->custno, IIF(ISNULL(a_artran->custno), '', a_artran->custno)), " + ;
                                             "invno  WITH IIF(LEFT(dsttype, 1) = 'R', a_arcash->invno, IIF(ISNULL(a_artran->invno), '',a_artran->invno)), " + ;
                                             "gltdes WITH IIF(dsttype='RD', IIF(ISNULL(a_arcash->ctranno), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf4->tranno), " + ;
                                                "'C# ' + ALLTRIM(a_arcash->custno) + ' Tran# '+ LTRIM(a_tmpf4->tranno) + ' ' + ALLTRIM(a_arcash->refno)), " + ;
                                                "IIF(dsttype='CD', IIF(ISNULL(a_artran->invno), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf4->tranno), " + ;
                                                "'C# ' + ALLTRIM(a_artran->custno) + ' IV# ' + LTRIM(a_tmpf4->tranno)), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf4->tranno))), " + ;
                                             "subdetl WITH IIF(NOT RIGHT(dsttype, 1) = 'C', a_tmpf4->custno + a_tmpf4->invno, ''), " + ;
                                             "glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", ;
                                             "", ;
                                             .t.)
      ELSE
        go_SQL.so_CurrentAlias.m_Replacebulk("custno WITH IIF(LEFT(dsttype, 1) = 'R', a_arycsh->custno, IIF(ISNULL(a_arytrn->custno), '', a_arytrn->custno)), " + ;
                                             "invno  WITH IIF(LEFT(dsttype, 1) = 'R', a_arycsh->invno, IIF(ISNULL(a_arytrn->invno), '', a_arytrn->invno)), " + ;
                                             "gltdes WITH IIF(dsttype='RD', IIF(ISNULL(a_arycsh->ctranno), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf5->tranno), " + ;
                                                "'C# ' + ALLTRIM(a_arycsh->custno) + ' Tran# '+ LTRIM(a_tmpf5->tranno) + ' ' + ALLTRIM(a_arycsh->refno)), " + ;
                                                "IIF(dsttype='CD', IIF(ISNULL(a_arytrn->invno), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf5->tranno), " + ;
                                                "'C# ' + ALLTRIM(a_arytrn->custno) + ' IV# ' + LTRIM(a_tmpf5->tranno)), " + ;
                                                "'Transaction #: ' + LTRIM(a_tmpf5->tranno))), " + ;
                                             "subdetl WITH IIF(NOT RIGHT(dsttype, 1) = 'C', a_tmpf5->custno + a_tmpf5->invno, ''), " + ;
                                             "glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", ;
                                             "", ;
                                             .t.)
      ENDIF
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Open temporary file
      IF lc_alias = "a_ardist"

        *-- Copy the entire content to a temporary VFP table
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, "", "F")

        *-- Close the backend table
        go_SQL.cmpA_tmpf4.m_CloseTable()

        *-- Open the main table in a different allias
        = g_opnfl(gf_ardistf, "a_ardis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_ardist", .t., ;
                  .f., "", .f., "F")

      ELSE

        *-- Copy the entire content to a temporary VFP table
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf3, "", "F")

        *-- Close the backend table
        go_SQL.cmpA_tmpf5.m_CloseTable()

        *-- Open the main table in a different allias
        = g_opnfl(gf_arydstf, "a_aryds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_arydst", .t., ;
                  .f., "", .f., "F")

      ENDIF

    CASE gc_applid = "IC" AND lc_detail = "N"

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno " + ;
                         " FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "TABLE", ;
                         IIF(lc_alias = "a_icdist", gc_idrvtmp + gc_tmpf2, gc_idrvtmp + gc_tmpf3))
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      IF lc_alias = "a_icdist"
        *-- Open the main table in a different alias
        = g_opnfl(gf_icdistf, "a_icdis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_icdist", .t., ;
                  .f., "", .f., "F")
      ELSE
        *-- Open the main table in a different alias
        = g_opnfl(gf_icydstf, "a_icyds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_icydst", .t., ;
                  .f., "", .f., "F")
      ENDIF

*\ [2 Lines] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.so_CurrentAlias.m_Replacebulk("glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                           "A", "", .t.)

    CASE gc_applid = "IC" AND lc_detail = "Y"
      *-- Inventory Control, Detail
      lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
      lc_ndxexp = [glfyear + glper + icsess + IIF(] + lc_sumexp + ;
                  [, "C", "P") + glacnt]

      lc_docexp = [applid + docno]

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)

      *-- Since the index based on the other table's field is not supported by
      *-- SQL framework, a copy of ICDIST/ICYDST is taken in to a temporary
      *-- table where the values from ICTRAN/ICYTRN is stored in a new column
      *-- of the temporary table and indexed. The temporary table is then
      *-- opened in the alias name of original table.
*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, SPACE(" + STR(FSIZE("APPLID", "a_ictran")) + ") AS applid, " + ;
                         "SPACE(" + STR(FSIZE("DOCNO", "a_ictran")) + ") AS docno, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "SQL TABLE", ;
                         IIF(lc_alias = "a_icdist", lf_Stemp4, lf_Stemp5))
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      IF lc_alias = "a_icdist"
        *-- Current file

        *-- Open temporary file
*\ [1 Line] PTR# 74180 06/22/04 TIAI Fix for performance optimization
        = g_opnfl(lf_Stemp4, ;
                  "a_tmpf4", ;
                  .t.)

        go_SQL.cmpA_Ictran.m_SetOrder("ttranno")
        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_ictran", .f.)

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
        go_SQL.so_CurrentAlias.m_Replacebulk("applid WITH IIF(ISNULL(a_ictran->applid), '', a_ictran->applid), " + ;
                                             "docno  WITH IIF(ISNULL(a_ictran->docno), '', a_ictran->docno), " + ;
                                             "gltdes WITH IIF(ISNULL(a_ictran->udref), '', 'Ref: ' + ALLTRIM(a_ictran->udref)), " + ;
                                             "subdetl WITH a_tmpf4->applid + a_tmpf4->docno, " + ;
                                             "glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", ;
                                             "", ;
                                             .t.)
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

        *-- Copy the entire content to a temporary VFP table
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf2, "", "F")

        *-- Close the backend table
        go_SQL.cmpA_tmpf4.m_CloseTable()

        *-- Open the main table in a different alias
        = g_opnfl(gf_icdistf, "a_icdis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_icdist", .t., ;
                  .f., "", .f., "F")

      ELSE
        *-- History file
*\ [1 Line] PTR# 74180 06/22/04 TIAI Fix for performance optimization
        = g_opnfl(lf_Stemp5, ;
                  "a_tmpf5", ;
                  .t.)

        go_SQL.cmpA_Icytrn.m_SetOrder("ttranno")
        go_SQL.so_CurrentAlias.m_SetRelation("tranno", "a_icytrn", .f.)

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
        go_SQL.so_CurrentAlias.m_Replacebulk("applid WITH IIF(ISNULL(a_icytrn->applid), '', a_icytrn->applid), " + ;
                                             "docno  WITH IIF(ISNULL(a_icytrn->docno), '', a_icytrn->docno), " + ;
                                             "gltdes WITH IIF(ISNULL(a_icytrn->udref), '', 'Ref: ' + ALLTRIM(a_icytrn->udref)), " + ;
                                             "subdetl WITH a_tmpf5->applid + a_tmpf5->docno, " + ;
                                             "glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", ;
                                             "", ;
                                             .t.)
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

        *-- Copy the entire content to a temporary VFP table
        go_SQL.so_CurrentAlias.m_CopyTo(gc_idrvtmp + gc_tmpf3, "", "F")

        *-- Close the backend table
        go_SQL.cmpA_tmpf5.m_CloseTable()

        *-- Open the main table in a different alias
        = g_opnfl(gf_icydstf, "a_icyds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_icydst", .t., ;
                  .f., "", .f., "F")

      ENDIF

    CASE gc_applid = "PR"
      *-- PayrollControl

      *-- Detail
      IF lc_detail = "Y"
        lc_sumexp = [RIGHT(] + lc_alias + [->dsttype, 1) = "C"]
        lc_ndxexp = [glfyear + glper + icsess + IIF(] + lc_sumexp + ;
                    [, "C", "P") + glacnt]

        *-- Set expressions and relations for document number lookup
        go_SQL.m_TableChangeCurrent(lc_alias)

        lc_sumexp = [LEFT(] + lc_alias + [->dsttype,1) = "C"]
        lc_ndxexp = [glfyear + glper + prsess + IIF(] + lc_sumexp + ;
                    [, "C", "P") + glacnt]

        *-- Set expression for document number lookup
        lc_docexp = lc_alias + [->checkno]
      ENDIF

      *-- Set expressions and relations for document number lookup
      go_SQL.m_TableChangeCurrent(lc_alias)

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      go_SQL.m_SQLSelect(lc_alias + ".*, RECNO('" + lc_alias+ "') AS dstrec, " + ;
                         "SPACE(" + STR(FSIZE("GLTDES", "a_gldunp")) + ") AS gltdes, " + ;
                         "SPACE(" + STR(FSIZE("SUBDETL", "a_gldunp")) + ") AS subdetl, " + ;
                         "000000000000000 AS marker, " + ;
                         "a_glacnt.glacnt AS Acctno " + ;
                         " FROM " + ;
                         go_SQL.cmp&lc_alias..sc_TableNameFull + SPACE(1) + lc_alias + SPACE(1) + ;
                         " LEFT OUTER JOIN " + go_SQL.cmpA_glacnt.sc_TableNameFull + " a_glacnt" + ;
                         " ON " + lc_alias + ".glacnt = a_glacnt.glacnt AND a_glacnt.glstat <> 'I' " + ;
                         " WHERE " + lc_cond, ;
                         "TABLE", ;
                         IIF(lc_alias = "a_prdist", gc_idrvtmp + gc_tmpf2, gc_idrvtmp + gc_tmpf3))
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

      *-- Close temporary file just created
      go_SQL.so_CurrentAlias.m_CloseTable()

      *-- Close the main table
      go_SQL.cmp&lc_alias..m_CloseTable()

      IF lc_alias = "a_prdist"
        *-- Open the main table in a different alias
        = g_opnfl(gf_prdistf, "a_prdis1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf2 + gc_extdbf, "a_prdist", .t., ;
                  .f., "", .f., "F")
      ELSE
        *-- Open the main table in a different alias
        = g_opnfl(gf_prydstf, "a_pryds1", .f., .f., "posted")

        *-- Open the temporary table in the alias name of original table
        = g_opnfl(gc_idrvtmp + gc_tmpf3 + gc_extdbf, "a_prydst", .t., ;
                  .f., "", .f., "F")
      ENDIF

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
      IF lc_detail = "Y"
        go_SQL.so_CurrentAlias.m_Replacebulk("gltdes WITH 'Check # ' + ALLTRIM(checkno), " + ;
                                             "subdetl WITH IIF(NOT RIGHT(dsttype, 1) = 'C', checkno, ''), " + ;
                                             "glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", "", .t.)
      ELSE
        go_SQL.so_CurrentAlias.m_Replacebulk("glacnt WITH IIF(ISNULL(acctno), '" + lc_suspen + "', glacnt)", ;
                                             "A", "", .t.)
      ENDIF
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

  ENDCASE

  go_SQL.m_TableChangeCurrent(lc_alias)

  go_SQL.so_CurrentAlias.m_CreateIndex(lc_tag, ;
                                       lc_ndxexp + ;
                                       IIF(EMPTY(lc_docexp), "", " + " + lc_docexp), ;
                                       "", .t., .t.)


RETURN
*------------------------------------------------------------------------------
*- End Procedure...: l_indkgl
*------------------------------------------------------------------------------

*\ [Begin] PTR# 74180 06/22/04 TIAI Fix for performance optimization
*\                                  Added new function
*------------------------------------------------------------------------------
*- Procedure..: L_REPLACE
*------------------------------------------------------------------------------
*- Description: Updates batch number and displays status message
*------------------------------------------------------------------------------
*- Calls......: None
*------------------------------------------------------------------------------
*- Passed:
*- Variables..: None
*-
*- Parameters.: pc_Expr, holds either "glbatch" or "batch"
*------------------------------------------------------------------------------
FUNCTION l_replace

PARAMETERS pc_expr

  REPLACE &pc_expr WITH lc_batchno

*\ [1 Line] PTR# 78127 01/13/05 TISP Check for last transaction date
  ld_LstTranDte = IIF(&lc_Alias.->trandte > ld_LstTranDte, &lc_Alias.->trandte, ld_LstTranDte)

  *-- Display processing message
  DO g_dspst WITH "Creating batch " + ALLTRIM(lc_batchno) + " " + ;
                  LEFT(lc_yearprd, 4) + "/" + RIGHT(lc_yearprd, 2) + ;
                  ", account " + ALLTRIM(glacnt) + "...", .t., ;
                  gn_msgline, "", "", ""

RETURN .t.
*------------------------------------------------------------------------------
*- End Procedure...: l_replace
*------------------------------------------------------------------------------
*\ [End] PTR# 74180 06/22/04 TIAI Fix for performance optimization

*------------------------------------------------------------------------------
*- File Name..: $Workfile:   SYLKGL.prg  $
*- Total Lines: 3299