*------------------------------------------------------------------------------
*- Version....: Sage Pro ERP 7.40.00
*- File Name..: $Workfile: SOPOST.H $
*- VCS Level..: $Revision: 206 $
*- Last Update: $Date: 7/18/07 5:00p $
*------------------------------------------------------------------------------
*- Copyright (C) 2006 Sage Accpac International, Inc.  All Rights Reserved.
*------------------------------------------------------------------------------

#include events.h
#include global.h
#include helpid.h

*-- Get table identifiers
#define Cn_CustDBF 1
#define Cn_MastDBF 2
#define Cn_TranDBF 3
#define Cn_BlnkDBF 4
#define Cn_TranCopyDBF 5

*-- Events
#define Cn_HdrEdit     1001
#define Cn_Reopen      1002
#define Cn_Close       1004
#define Cn_Comment     1008
#define Cn_Header      1012
#define Cn_LineItems   1013
#define Cn_ApplyLine   1016
#define Cn_CopyFrom    1017
#define Cn_Release     1018
#define Cn_AddShip     1019
#define Cn_SelSerial   1020
#define Cn_Detadd      1030
#define Cn_Detinquiry  1031
#define Cn_Convert     1032
#define Cn_Void        1033
#define Cn_Detail      1034
#define Cn_Selinq      1035
#define Cn_Sequence    1300


*-- Commission defines
#define Cc_SplitComm  "S"
#define Cc_PersonComm "P"
#define Cc_NoComm     "N"
#define Cc_EmptyComm  " "

*-- Paramters for l_setvar
#define Cn_Clear 0
#define Cn_Init  1
#define Cn_Load  2

*-- Parameters for v_editst
#define Cl_Force    .t.
#define Cl_NoForce  .f.

*-- Parameters for m_CvtVar
#define Cl_CvtFromTable .t.
#define Cl_CvtToTable   .f.

*-- Parameters for object locking function
#define Cl_SetLock     .t.
#define Cl_ReleaseLock .f.
#define Cl_Retry       .t.
#define Cl_NoRetry     .f.
#define Cl_RollBack    .t.
#define Cl_Commit      .f.

*-- Parameters for field validation functions
#define Cl_Verbose  .t.
#define Cl_Default  .t.

*-- Browse parameters
#define Cl_BrowForce    .t.
#define Cl_BrowNoForce  .f.

*-- Field lists for g_trykey selection browses
#define Cc_FldsCust "Custno :H = [Customer], " + ;
        "Company :H = [Company Name] :40, " + ;
        "Contact :25, Phone"

#define Cc_FldsComp "Company :H = [Company Name] :45, " + ;
        "Custno :H = [Customer], " + ;
        "Contact :25, Phone"

#define Cc_FldsPhon "Phone, Custno :H = [Customer], " + ;
        "Company :H = [Company Name] :45, " + ;
        "Contact :25"

#define Cc_FldsShip "custno :H = [Customer Code], " + ;
        "company :H = [Company Name Phone] :25, " + ;
        "contact :20, phone"

#define Cc_FldsItem "item :H = [Item Code], " + ;
        "itmdesc :H = [Item Description] :25 "

#define Cc_FldsIDsc "itmdesc :H = [Item Description] :25, " + ;
        "item :H = [Item Code]"

#define Cc_FldsLoct "loctid  :h = gc_locta," + ;
        "locdesc :h = [Description]," + ;
        "phone, addrs1, addrs2, city, state, zip, country"

#define Cc_FldsILoc [a_icitem->item :27 :h = "Item Code",] + ;
        [a_iciloc->loctid :12 :h = gc_locta,] + ;
        [a_icitem->itmdesc :20 :h = "Description",] + ;
        [a_iciloc->lonhand :10 :h = "On hand",] + ;
        [a_iciloc->lsupplr :8 :h = "Def Supl",] + ;
        [a_iciloc->ytdslqt :10 :h = "YTD Sls",] + ;
        [a_iciloc->ytdusqt :12 :h = "YTD Usage"] + ;
        [key "] + pc_item + ["]

*-- Called g_chkpct instead of g_ccypct
#define Cc_FldsOrdr "sono :H = [Order #] :P=gc_docpic," + ;
        "type=sotype :8," + ;
        "sodate :11 :H=[Date]," + ;
        "order=ornum :10," + ;
        "cust=custno :12," + ;
        IIF(gl_mc, "currid :H = [Curr]," , "") + ;
        "total=ordamt+shpamt :15 :P=" + ;
        IIF(gl_mc, "g_chkpct([], currid, @la_currid)", "gc_ccypct") + "," + ;
        "open=IIF(ordamt=0 AND (shpamt <> 0 OR " + ;
        "sostat='C'), [Shipped], " + ;
        IIF(gl_mc, "ordamt) :P=g_chkpct([], currid, @la_currid)", ;
        "STR(ordamt,12,2))") + " :17 " + ;
        "WHEN r_algncol(" + IIF(gl_mc, "8", "7") + ", 1)"

#define Cc_FldsUMS  "umsconv :14 :h = [U/M ID]," + ;
        "desc = TRIM(umssdes)+[ / ]+umsdesc :h=[Description]," + ;
        "cnvf :h = [Factor]"

#define Cc_NoDelRecs     " NOT DELETED()"

#define Cc_BrowShip   "Cshipno :H=[Customer Ship-To Code], "    + ;
        "Company :H=[Company Name] :25, "         + ;
        "Contact :20, Phone "

#define Cc_BrShipCu   "Cshipno :H=[Ship-To Cust ID], "    + ;
        "Company :H=[Company Name] :45, "         + ;
        "Contact :25, Phone "                     + ;
        "FOR " + Cc_NoDelRecs

#define Cc_FldsLink "scode :h=[Sales Category], icode :h=[Item Category]"
#define Cc_FldsTrms "chrvl :h = [Terms Code]," + ;
        "descrip :h = [Description]"

#define Cc_FldsSlsm "chrvl :H = [Slsperson], descrip :H = [Description]"
#define Cc_FldsTerr "chrvl :H = [Territory], descrip :H = [Description]"

*-- Parameter values passed to this program
#define Cc_EntSalesOrder   "N"
#define Cc_EditSalesOrder  "E"
#define Cc_EntReturn       "R"
#define Cc_EntDropShip     "D"  && gl_sbtmod
#define Cc_ReleBO          "K"
#define Cc_EntBid          "B"

*-- Entering a return
#define Cl_EntReturn       (a_somast->sotype = "R")
#define Cl_EntBid          (a_somast->sotype = "B")

*-- Releasing a blanket order
#define Cl_ReleBO       (ThisFormSet.pc_SoType = Cc_ReleBO)

#define Cc_DefShpTo       "Default "
#define Cc_UseCustAddr    "Customer"
#define Cc_UseShipAddr    "Ship-To "

*-- Maximum supportable number of SO line items
#define Cn_MaxLine (10 ** FSIZE("tranlineno", "ac_Detail") - 1)

*-- Seek expression on temporary detail table
#define Cc_DtlKey  ac_Detail->sono + STR(ac_Detail->tranlineno, 4)

*-- Logicals for calls to L_UPDIQ
#define Cl_TmAloc  .t.
#define Cl_SoAloc  .f.

*-- Quantity available checks
#define Cn_QtyAvl    a_iciqty->qonhand - ABS(a_iciqty->qsoaloc) - ;
        a_iciqty->qwoaloc - a_iciqty->qtmaloc
#define Cc_QtyAvl    "a_iciqty->qonhand - ABS(a_iciqty->qsoaloc) " + ;
        " - a_iciqty->qwoaloc - a_iciqty->qtmaloc"

#define Cn_SerlQtyAvl    a_iciqty->qonhand - ABS(a_iciqty->qsoaloc) - ;
        ABS(a_iciqty->qwoaloc) - ABS(a_iciqty->qtmaloc)
#define Cc_SerlQtyAvl    "a_iciqty->qonhand - ABS(a_iciqty->qsoaloc) " + ;
        " - ABS(a_iciqty->qwoaloc) - ABS(a_iciqty->qtmaloc)"

*-- Cost, price, and quantity decimals
#define Cn_CostDec     5
#define Cn_PriceDec    5
#define Cn_QtyDec      6

*-- defines for initializing header vars
#define Cl_SetAll      .t.      && Initialize all vars
#define Cl_SetCust     .f.      && Initialize only customer based vars

*-- Used as parameter call for shipping state field
#define Cn_ShpStateFld -1         && Used for w_mast, v_mast of lc_state

*-- For call to l_putln
#define Cl_Serial      .t.
#define Cl_NotSerial   .f.

*-- Picture clause for numeric fields
#define Cc_PictNumFld  REPLICATE([#], 12) + [.##]

*-- To indicate whether called during saving or not
#define Cl_Saving      .t.
#define Cl_NotSaving   .f.

*-- No. of records that can be displayed in browse
#define Cn_TotBrowRec  3

*-- Customer status messages
#define Cc_CustDel       "Customer has been deleted."
#define Cc_CustCredHold  "Customer on Credit Hold."

#define Cc_CustInactive  "Customer status is inactive."

#define Cc_CancChangeMsg  "Cancel all changes?"

*-- Size for toggle ("X") in browses
#define Cc_ToggleSize     "2"


#define Cl_Saving      .t.
#define Cn_CtrlW       23

